#!/usr/bin/python2.2

#        +-----------------------------------------------------------------------------+
#        | GPL                                                                         |
#        +-----------------------------------------------------------------------------+
#        | Copyright (c) Arturo Gonzalez Ferrer <arturogf@ugr.es>                      |
#        |                                                                             |
#        | This program is free software; you can redistribute it and/or               |
#        | modify it under the terms of the GNU General Public License                 |
#        | as published by the Free Software Foundation; either version 2              |
#        | of the License, or (at your option) any later version.                      |
#        |                                                                             |
#        | This program is distributed in the hope that it will be useful,             |
#        | but WITHOUT ANY WARRANTY; without even the implied warranty of              |
#        | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               |
#        | GNU General Public License for more details.                                |
#        |                                                                             |
#        | You should have received a copy of the GNU General Public License           |
#        | along with this program; if not, write to the Free Software                 |
#        | Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. |
#        +-----------------------------------------------------------------------------+


import sys
import pygtk
pygtk.require('2.0')
import gtk
import gtk.glade
import gnome.applet
import gnome.ui
import os.path
import re
import pycentrino_globals as pglobals

class pycentrino:
        
    def cleanup(self,event,widget):
        del self.applet

    # callback para llamada cada 1 segundo 
    def timeout_callback(self,event):
        
        # si queremos parar la funcion de timeout debemos devolver 0 (en caso de que no haya soporte acpi)
        if self.lack_p_acpi and self.lack_t_acpi:
            return 0
        else:
            info = self.read_proc_info()
            self.tooltip_text = info[0] + " " + info[1]
            self.tooltips.set_tip (self.ev_box, self.tooltip_text)
            
            if info[0] is "":
                self.tooltip_text = str(100.0 - float(self.active_t_state*(100/self.throttling_states))) + "%"
                self.prog.set_text(self.tooltip_text)
                self.tooltips.set_tip(self.ev_box, self.tooltip_text)
                self.prog.set_fraction(float(self.throttling_states-self.active_t_state)/float(self.throttling_states))
            else:
                self.tooltip_text = (info[0]+" "+info[1])
                self.tooltips.set_tip(self.ev_box,self.tooltip_text)
            return 1

    # callback para las signals de entrada y salida en el ev_box, actualizar el valor del tooltip
    def update_info(self,widget,event):
        info = self.read_proc_info();
        self.tooltips.set_tip(self.ev_box, info[0] + " " + info[1]);
                    
    # callback para crear el menu contextual
    def button_press(self,widget,event):
        if event.type == gtk.gdk.BUTTON_PRESS and event.button == 3:
            self.create_menu()
    
    def about_info(self,event,data=None):
        about = gnome.ui.About("CPU performance stats applet","0.1","GPL","Applet to check throttling and performance states",["Arturo Gonzalez"],["Arturo Gonzalez"],"Arturo Gonzalez",self.logo_pixbuf)
        about.show()
    
    def properties(self,event,data=None):
        self.preferences.show()
    
    # funcion de actualizacion de la informacion extraida de /proc/acpi
    def read_proc_info(self):

        # throttling support
        if (os.path.isfile("/proc/acpi/processor/CPU0/throttling")):
            f_throt = open("/proc/acpi/processor/CPU0/throttling","r");
            cont = 1;

            for line in f_throt:
                if cont == 1:
                    tmp = re.split('\W+',line)
                    self.throttling_states = int(tmp[2])
                else:
                    if cont == 2:
                        tmp = re.split('\W+', line)
                        self.active_t_state = int(tmp[2][1])
                    else:
                        break
                cont = cont + 1
                    
            f_throt.close()
        else:
            self.lack_t_acpi = 1

        # power support
        if (os.path.isfile("/proc/acpi/processor/CPU0/power")):
            f_per = open("/proc/acpi/processor/CPU0/power","r");
            cont = 1;

            for line in f_per:
                if cont == 1:
                    tmp = re.split('\W+',line)
                    self.active_cpu_state = tmp[2][1]
                else:
                    if cont == 3:
                        tmp = re.split('\W+', line)
                        self.bus_activity = tmp[3]
                    else:
                        if cont != 2:
                            break

                cont = cont + 1
                    
            f_per.close()
        else:
            self.lack_p_acpi = 1

        #devolvemos "" si va bien o mensaje si falta algo
        if self.lack_t_acpi and self.lack_p_acpi:
            return ("lack of throttling acpi support","lack of power acpi support")
        else:
            if self.lack_t_acpi:
                return ("lack of throttling acpi support","")
            else:
                if self.lack_p_acpi:
                   return("","lack of power acpi support")
                else:
                    return("","")


    # callback para la creacion del menu contextual boton derechso
    def create_menu(self):
        self.applet.setup_menu(self.propxml,self.verbs,None)


    # preferences window callbacks 
    def on_properties_delete_event(self,widget,event):
        widget.hide()
        return gtk.TRUE

    def on_checkbutton1_toggled(self,widget):
        self.checks[0] = widget.get_active()
        print self.checks
    def on_checkbutton2_toggled(self,widget):
        self.checks[1] = widget.get_active()
        print self.checks
    def on_checkbutton3_toggled(self,widget):
        self.checks[2] = widget.get_active()
        print self.checks
    def on_checkbutton4_toggled(self,widget):
        self.checks[3] = widget.get_active()
        print self.checks
    def on_checkbutton5_toggled(self,widget):
        self.checks[4] = widget.get_active()
        print self.checks

    def __init__(self,applet,iid):

        self.timeout_interval = 1000        
        self.throttling_states = 0
        self.active_t_state = "T0"
        self.bus_activity = ""
        self.actual_cpu_state = "C1"
        self.lack_t_acpi = 0
        self.lack_p_acpi = 0
        self.dict = {}
        self.bar_bg_color = "#C5D2C8"
        self.bar_fg_color = "#C5D2C8"
        self.tooltip_text = ""
        self.checks = [0,0,0,0,0]

        self.propxml="""
        <popup name="button3">
        <menuitem name="Item 1" verb="Props" label="_Preferences..." pixtype="stock" pixname="gtk-properties"/>
        <menuitem name="Item 2" verb="About" label="_About..." pixtype="stock" pixname="gnome-stock-about"/>
        </popup>
	"""
        
        self.verbs = [ ( "Props", self.properties ),
                       ( "About", self.about_info )  
	             ]
            
        gnome.init(pglobals.name, pglobals.version)

        self.logo = gtk.Image()
        self.logo.set_from_file(os.path.join(pglobals.image_dir,'centrino.gif'))
        self.logo_pixbuf = self.logo.get_pixbuf()
        self.applet = applet

        self.tooltips = gtk.Tooltips()
        self.hbox = gtk.HBox()
        applet.add(self.hbox)

        self.ev_box = gtk.EventBox()
        self.ev_box.connect("button-press-event",self.button_press)
        self.ev_box.connect("enter-notify-event", self.update_info)
        self.hbox.add(self.ev_box)

        self.prog = gtk.ProgressBar()

        self.prog.modify_bg(gtk.STATE_NORMAL, gtk.gdk.color_parse(self.bar_bg_color))
        self.prog.modify_fg(gtk.STATE_NORMAL, gtk.gdk.color_parse("white"))
        self.prog.modify_bg(gtk.STATE_ACTIVE, gtk.gdk.color_parse(self.bar_bg_color))
        self.prog.modify_fg(gtk.STATE_ACTIVE, gtk.gdk.color_parse("white"))
        self.prog.modify_bg(gtk.STATE_PRELIGHT, gtk.gdk.color_parse(self.bar_bg_color))
        self.prog.modify_fg(gtk.STATE_PRELIGHT, gtk.gdk.color_parse("white"))
        self.ev_box.add(self.prog)

        gtk.timeout_add(self.timeout_interval,self.timeout_callback, self)

        applet.connect("destroy",self.cleanup,None)
        applet.show_all()

        wT = gtk.glade.XML(os.path.join(pglobals.glade_dir, "pycentrino.glade"))
        preferencesDialog = wT.get_widget('properties')
        self.preferences = preferencesDialog
        wT.signal_autoconnect(self)

def pycentrino_applet_factory(applet, iid):
    pycentrino(applet,iid)
    return gtk.TRUE

if len(sys.argv) == 2 and sys.argv[1] == "run-in-window":
    main_window = gtk.Window(gtk.WINDOW_TOPLEVEL)
    main_window.set_title("Pycentrino Applet")
    main_window.connect("destroy", gtk.mainquit) 
    app = gnome.applet.Applet()
    pycentrino_applet_factory(app, None)
    app.reparent(main_window)
    main_window.show_all()
    gtk.main()
    sys.exit()

if __name__ == '__main__':
    gnome.applet.bonobo_factory("OAFIID:GNOME_PycentrinoApplet_Factory",
                                gnome.applet.Applet.__gtype__, 
                                "hello", "0", pycentrino_applet_factory)

    
