package es.ugr.amaro.readresources;

import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

public class MainActivity extends AppCompatActivity implements View.OnClickListener{


    TextView tv;
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.milayout);
        tv = (TextView) findViewById(R.id.texto);
        Button button = findViewById(R.id.button);
        button.setOnClickListener(this);
    }

    @Override
    public void onClick(View view) {

    tv.append("\nLeyendo datos de res/raw/datos1.txt:");
        InputStream input=
                getResources().openRawResource(R.raw.datos1);
        InputStreamReader stream=
                new InputStreamReader(input);
        BufferedReader buffer =
                new BufferedReader(stream);
//        new BufferedReader(stream,8192);

        Double a=0.;
        Double b=0.;

        try{
            String linea;
            while(true){
                linea=buffer.readLine();
                if(linea==null) break;
                tv.append("\n"+linea);
                a= extraeDouble(linea,1);
                b= extraeDouble(linea,2);
                tv.append("\na="+a+" , b="+b);

            }
            input.close();
            stream.close();
            buffer.close();
        }catch(Exception e){
            tv.append("\n "+e);
        }
        tv.append("\nEnd of file");
    }

    double extraeDouble(String s, int posicion){

        String cadena1,cadena2;
        String primera="";
        String segunda=s;

        for(int i=0;i< posicion ;i++) {

            int blanco = segunda.trim().indexOf(" ");
            if(blanco >0) {
                cadena1 = segunda.trim().substring(0, blanco);
                cadena2 = segunda.trim().substring(blanco);
                cadena2 = cadena2.trim();
            }else{
                cadena1= segunda;
                cadena2="";
            }
            primera = cadena1;
            segunda = cadena2;
        }
            return Double.parseDouble(primera);
    }


}
