package es.ugr.amaro.ligaduras;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.Toast;

public class MainActivity extends AppCompatActivity
                    implements View.OnClickListener{

    boolean continuar=true;
    float vinicial;
    float velocidad;
    float aceleracion;
    float energia;
    int dt=40;
    int tiempo=0;
    Thread hilo=null;
    DinamicaView dinamica;
    Trayectoria trayectoria=new Trayectoria(100,100);
    float s;

    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);


        dinamica=new DinamicaView(this);
        setContentView(dinamica);
        dinamica.setOnClickListener(this);
        hilo = new Thread(dinamica);
        hilo.start();


    }

    // detenemos el hilo si pausa
    @Override
    public void onPause(){
        super.onPause();
        continuar=false;
    }

    // reiniciamos el hilo si resume
    @Override
    public void onResume(){
        super.onResume();
        continuar=true;
        dt=40;

        if(!hilo.isAlive()){
            hilo = new Thread(dinamica);
            hilo.start();
        }
    }

    @Override
    public void onClick(View v) {

        if(dt==40){
            dt=0;
        } else dt=40;

    }

    class DinamicaView extends View implements Runnable{

        float x,y,xmin,xmax,ymin,ymax;  // coordenadas
        float vx,vy;
        Paint paintFondo,paintParticula,paint,
                paintCurva,paintVector;
        Path path;
        boolean cambio=true;

        public DinamicaView(Context context) {
            super(context);
            // Colores para el dibujo y tamaño del texto
            paintFondo=new Paint();
            paintParticula=new Paint();
            paint=new Paint();
            paintFondo.setColor(Color.rgb(255,255,200));
            paintParticula.setColor(Color.RED);
            paint.setColor(Color.BLACK);
            paintCurva=new Paint();
            paintCurva.setStyle(Paint.Style.STROKE);
            paintCurva.setColor(Color.BLUE);
            paintVector=new Paint();
            paintVector.setStrokeWidth(10);
            paintVector.setColor(Color.DKGRAY);
        }

        // obtiene geometria del canvas
        @Override
        protected void onSizeChanged(
                int w, int h, int oldw,int oldh){
            s=getResources().getDisplayMetrics().density;
            xmin=0;
            xmax=w;
            ymax=h;
            ymin=0;
            // punto inicial
            x=xmin;
            y=ymin;

            float anchura=w;
            float altura=h;
            trayectoria=new Trayectoria(anchura,altura);

            vinicial=0.1f*s;  //velocidad inicial
            velocidad=vinicial;
            aceleracion=0.0001f*s;
            energia=0.5f * velocidad * velocidad
                    - aceleracion * ymin;
            // construye el path de la trayectoria
            path=new Path();
            path.moveTo(xmin,ymin);
            for (float xi=xmin; xi<anchura-xmin;xi++){
                float yi=trayectoria.getY(xi);
                path.lineTo(xi,yi);
            }
        }

        @Override
        public void run() {

            while(continuar){
                cambiaPosicion3();
                postInvalidate();
                try { Thread.sleep( dt ); }
                catch ( InterruptedException e ){  }
            }
        }

        public void cambiaPosicion3() {

            try {
                float[] tangente = {0, 0};
                tiempo = tiempo + dt;
                tangente = trayectoria.getTangente(x);
                float tangenteX = tangente[0];
                float tangenteY = tangente[1];
                vx = tangenteX * velocidad;
                vy = tangenteY * velocidad;
                float aT = aceleracion * tangenteY;
                velocidad = velocidad + aT * dt;
                float cinetica = velocidad * velocidad / 2;
                y = (cinetica - energia) / aceleracion;
                if (vy == 0.0) {
                    x = (x + velocidad * dt);
                    y = trayectoria.getY(x);
                    cambio = !cambio;
                }

                if (cambio) x = trayectoria.getX2(y);
                else x = trayectoria.getX1(y);

                // si llega arriba invertimos velocidad
                if (y < ymin) velocidad = -velocidad;
            }catch(Exception e){
                x=xmin;
                y=ymin;
                velocidad=vinicial;
            }



        }

        @Override
        public void onDraw(Canvas canvas ){

            paint.setTextSize(20*s);
            paintCurva.setStrokeWidth(3*s);
            canvas.drawPaint(paintFondo);

                canvas.drawPath(path, paintCurva);
                canvas.drawCircle(x, y, 15 * s, paintParticula);
                canvas.drawText("x=" + x + " y=" + y, 40 * s, 20 * s, paint);
                canvas.drawText("t=" + tiempo, 40 * s, 40 * s, paint);
                canvas.drawText("v=" + velocidad, 40 * s, 60 * s, paint);
                canvas.drawText("Componentes de la velocidad", 40 * s, 100 * s, paint);
                float e = 50 * s; // escala para vector
                canvas.drawLine(x, y, x + e * vx, y + e * vy, paintVector);
                canvas.drawText("V", x + e * vx + 10 * s, y + e * vy - 10 * s, paint);
                canvas.drawText("VX=" + vx, 40 * s, 120 * s, paint);
                canvas.drawText("VY=" + vy, 40 * s, 140 * s, paint);



        }
    }   // fin dinamica


    //  clase con la trayectoria de una particula
    class Trayectoria{

        float yMax,x0;
        Trayectoria(float anchura, float altura){
            yMax=altura;
            x0=anchura/2;
        }

        float getY(float x){
            float xx0=(x-x0)/x0;
            float y=yMax*(1-xx0*xx0);
            return y;
        }

        // raiz positiva de la funcion inversa
        float getX1(float y){
            double raiz,radicando;
            radicando=Math.max(0f,1-y/yMax);
            raiz=Math.sqrt(radicando);
            float x1=(float) (x0+x0*raiz);
            return x1;
        }
        // raiz negativa de la funcion inversa
        float getX2(float y){
            double raiz,radicando;
            radicando=Math.max(0f,1-y/yMax);
            raiz=Math.sqrt(radicando);
            float x2=(float) (x0-x0*raiz);
            return x2;
        }

        // componente y del vector unitario tangente a la curva
        float[] getTangente(float x){
            float[] tangente=new float[2];
            float xx0=(x-x0)/x0;
            float derivada=-yMax*2*xx0/x0;
            double denominador=Math.sqrt(1+derivada*derivada);
            tangente[0]=(float) (1/denominador);
            tangente[1]=(float) (derivada/denominador);
            return tangente;

        }
    }

}


