package es.ugr.amaro.jerrygarcia;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;

public class MainActivity extends AppCompatActivity {


    float d,s;
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        Pintura miPintura = new Pintura(this);
        setContentView(miPintura);
        s=getResources().getDisplayMetrics().scaledDensity;
        d=getResources().getDisplayMetrics().density;
    }

    public class Pintura extends View{

        int indiceImagen=R.drawable.jerry_garcia;
        Drawable imagen=getResources().getDrawable(indiceImagen);

        public Pintura(Context context) {
            super(context);
        }

        @Override
        public void onDraw(Canvas canvas){

            Paint p=new Paint();
            p.setColor(Color.WHITE);
            canvas.drawPaint(p);

            int bottom=getBottom();
            int right=getRight();
            float ratioScreen=(float) bottom/right;

            int anchuraIm= imagen.getIntrinsicWidth();
            int alturaIm= imagen.getIntrinsicHeight();
            float ratio= (float) alturaIm/anchuraIm;

            int anchura,altura;
            // ajusta el ancho
            if(ratio<ratioScreen){
                anchura=right;
                altura= (int) (anchura*ratio);
            } else {
                altura=bottom;
                anchura=(int)(altura/ratio);
            }

            imagen.setBounds(0,0,anchura,altura);
            imagen.draw(canvas);

            p.setColor(Color.YELLOW);
            p.setTextSize(25*s);
            p.setShadowLayer (1*d, -3*d, 3*d, Color.BLACK);
            canvas.drawText(""+anchuraIm+"x"+alturaIm+" ratio:"+
                    ratio,  25*d, 50*d, p);
            canvas.drawText(""+right+"x"+bottom+" ratio:"+
                    ratioScreen,25*d,90*d,p);
            canvas.drawText(""+anchura+"x"+altura,25*d,130*d,p);
        }
    }
}







