package es.ugr.amaro.runnable;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.LinearLayout;

public class MainActivity extends AppCompatActivity {

    boolean continuar=true;
    String mensaje="";
    int[] contador={0,0};
    TextoAnimado texto,texto2;
    Thread hilo,hilo2;
    float s;
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.milayout);
        LinearLayout ll = findViewById(R.id.layout);
        s=getResources().getDisplayMetrics().density;

        LinearLayout.LayoutParams params=new LinearLayout.LayoutParams(600,100);

        texto= new TextoAnimado(this,40,0);
        texto.setLayoutParams(params);
        ll.addView(texto);

        texto2= new TextoAnimado(this,200,1);
        texto2.setLayoutParams(params);
        texto2.setBackgroundColor(Color.YELLOW);
        ll.addView(texto2);

        hilo= new Thread(texto);
        hilo.start();
        hilo2= new Thread(texto2);
        hilo2.start();
    }

    @Override
    protected void onPause() {
        super.onPause();
        continuar=false;
    }

    @Override
    protected void onResume() {
        super.onResume();
        continuar=true;
        if(!hilo.isAlive()) {
            hilo=new Thread(texto);
            hilo.start();
        }
        if(!hilo2.isAlive()){
            hilo2=new Thread(texto2);
            hilo2.start();
        }
    }

    class TextoAnimado extends View implements Runnable
    {
        int retraso;
        int i;
        Paint paint=new Paint();
        public TextoAnimado(Context context, int retraso, int i) {
            super(context);
            this.retraso=retraso;
            this.i=i;
            paint.setColor(Color.BLACK);
            paint.setTextSize(20*s);
            paint.setAntiAlias(true);
        }

        @Override
        protected void onDraw(Canvas canvas){
            super.onDraw(canvas);
            canvas.drawText(mensaje,30*s,30*s,paint);
        }

        public void run() {

            while(continuar){
                try{Thread.sleep(retraso);}
                catch(InterruptedException e){;}
                contador[i]++;
                mensaje="Contador: "+contador[i];
                postInvalidate();
            }
        }

    }


}
