package es.ugr.amaro.colortrap;

import android.graphics.Color;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

public class MainActivity extends AppCompatActivity implements View.OnClickListener{

    Button buttonLevel;
    Button[] buttonColor= new Button[10];
    View[][] v = new View[5][5];
    int aciertos=0, fallos=0;
    int level=0;
    int rc,gc,bc;
    int colorMax,iColor,solucion,pulsado;
    TextView mensajeView,textAciertos,textFallos;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.layout);

        textAciertos=findViewById(R.id.aciertos);
        textFallos=findViewById(R.id.fallos);

        v[0][0] = findViewById(R.id.v11);
        v[0][1] = findViewById(R.id.v12);
        v[0][2] = findViewById(R.id.v13);
        v[0][3] = findViewById(R.id.v14);
        v[0][4] = findViewById(R.id.v15);
        v[1][0] = findViewById(R.id.v21);
        v[1][1] = findViewById(R.id.v22);
        v[1][2] = findViewById(R.id.v23);
        v[1][3] = findViewById(R.id.v24);
        v[1][4] = findViewById(R.id.v25);
        v[2][0] = findViewById(R.id.v31);
        v[2][1] = findViewById(R.id.v32);
        v[2][2] = findViewById(R.id.v33);
        v[2][3] = findViewById(R.id.v34);
        v[2][4] = findViewById(R.id.v35);
        v[3][0] = findViewById(R.id.v41);
        v[3][1] = findViewById(R.id.v42);
        v[3][2] = findViewById(R.id.v43);
        v[3][3] = findViewById(R.id.v44);
        v[3][4] = findViewById(R.id.v45);
        v[4][0] = findViewById(R.id.v51);
        v[4][1] = findViewById(R.id.v52);
        v[4][2] = findViewById(R.id.v53);
        v[4][3] = findViewById(R.id.v54);
        v[4][4] = findViewById(R.id.v55);

        Button buttonNext = findViewById(R.id.buttonNext);
        buttonLevel = findViewById(R.id.buttonLevel);
        buttonNext.setOnClickListener(this);
        buttonLevel.setOnClickListener(this);
        mensajeView=findViewById(R.id.mensajeView);

        buttonColor[0] = findViewById(R.id.b0);
        buttonColor[1] = findViewById(R.id.b1);
        buttonColor[2] = findViewById(R.id.b2);
        buttonColor[3] = findViewById(R.id.b3);
        buttonColor[4] = findViewById(R.id.b4);
        buttonColor[5] = findViewById(R.id.b5);
        buttonColor[6] = findViewById(R.id.b6);
        buttonColor[7] = findViewById(R.id.b7);
        buttonColor[8] = findViewById(R.id.b8);
        buttonColor[9] = findViewById(R.id.b9);
        for(int i=0; i<10; i++) buttonColor[i].setOnClickListener(this   );
        setColors();
    }  //onCreate

    public void setColors() {
        int r, g, b,max,dmax,ncolores;
        double dr, dg, db;

        if(aciertos >= fallos) level=(aciertos-fallos)/10;
        dmax=level%6;
//        if(level > 12) level=12;
        if(level==12) mensajeView.setText("Perfect color vision");
        buttonLevel.setText("Nivel "+level);
        int maxlevel=255-dmax*40;
        if (maxlevel < 0) maxlevel=10;

        for (int i = 0; i < 5; i++) {
            for (int j = 0; j < 5; j++) {

                max=maxlevel;
                if(i==2 & j==2)max=255;
                dr = Math.random();
                dg = Math.random();
                db = Math.random();
                r = (int) Math.round(dr * max);
                g = (int) Math.round(dg * max);
                b = (int) Math.round(db * max);
                v[i][j].setBackgroundColor(Color.rgb(r, g, b));

                if (i == 2 && j == 2) {
                    rc = r;
                    gc = g;
                    bc = b;
                }
            }
        }

        ncolores=5;
        if(level>=6)ncolores=10;
        colorMax=rc;
        solucion=rc/(255/ncolores);
        iColor=0;
        if(gc> colorMax){ colorMax=gc; iColor=1; solucion=gc/(255/ncolores);}
        if(bc> colorMax){ colorMax=bc; iColor=2; solucion=bc/(255/ncolores);}

//  Color de los botones
        for (int i = 1; i <= ncolores; i++) {
                r=i*rc*255/colorMax/ncolores;
                g=i*gc*255/colorMax/ncolores;
                b=i*bc*255/colorMax/ncolores;
            buttonColor[i-1].setBackgroundColor(Color.rgb(r, g, b));
        }

    if(level<6) for(int i=6; i<11;i++)
        buttonColor[i-1].setBackgroundColor(Color.rgb(255, 255, 255));

    }  // setColors

    @Override
    public void onClick(View view) {
        if (view.getId()==R.id.buttonNext) setColors();
        if (view.getId()==R.id.buttonLevel) {
            level++;
            aciertos=level*10;
            fallos=0;
            setColors();
        }

        pulsado=0;
        if (view.getId()==R.id.b0) pulsado=1;
        if (view.getId()==R.id.b1) pulsado=2;
        if (view.getId()==R.id.b2) pulsado=3;
        if (view.getId()==R.id.b3) pulsado=4;
        if (view.getId()==R.id.b4) pulsado=5;
        if (view.getId()==R.id.b5) pulsado=6;
        if (view.getId()==R.id.b6) pulsado=7;
        if (view.getId()==R.id.b7) pulsado=8;
        if (view.getId()==R.id.b8) pulsado=9;
        if (view.getId()==R.id.b9) pulsado=10;

        if(pulsado>0) {
            String mensaje = "Acierto";
            if (pulsado == solucion) aciertos++;
            else if (pulsado == solucion + 1) aciertos++;
            else {
                fallos++;
                mensaje = "fallo";
            }

            Toast.makeText(this, mensaje, Toast.LENGTH_SHORT).show();
            textAciertos.setText("Aciertos:" + aciertos);
            textFallos.setText("Fallos:" + fallos);
        }
    }
}  // MainActivity