package es.ugr.amaro.hilos;

import android.os.Handler;
import android.os.Message;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.widget.TextView;

public class MainActivity extends AppCompatActivity {

    Handler handler=new Controlador();
    TextView texto1,texto2;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.milayout);
        texto1=(TextView) findViewById(R.id.texto1);

        Hilo hilo1=new Hilo(10,100);
        Hilo hilo2=new Hilo(5,200);
        hilo2.setPriority(7);
        hilo1.start();
        hilo2.start();
    }

    class Hilo extends Thread{
        int maximo,tiempo;

        Hilo(int n,int t){
            maximo=n;
            tiempo=t;
        }

        @Override
        public void run(){

            for (int i=0;i<=maximo;i++){
                try{
                    Thread.sleep(tiempo);
                }
                catch (InterruptedException e){ ; }

// Construye el mensaje
// para enviar al controlador handler
                Message msg=handler.obtainMessage();
                // inserta datos en el mensaje
                //enpaquetandolos en un bundle
                Bundle b =new Bundle();
                b.putInt("i",i);
                b.putString("thread", currentThread().toString());
                msg.setData(b);
                // envia el mensaje
                handler.sendMessage(msg);
            }
        }
    }

    // Controlador para recibir mensajes del hilo
    class Controlador extends Handler {

        public void handleMessage(Message msg){
            int total;
            // recibe los datos enviados en el mensaje msg

            total=msg.getData().getInt("i");
            String thread=msg.getData().getString("thread");
            texto1.append("\ni="+total+"   "+thread);
        }
    }
}
