package es.ugr.amaro.movimientorectilineo;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.Toast;

public class MainActivity extends AppCompatActivity {

    boolean continuar=true;
    float velocidad;
    float aceleracion;
    float energia;
    int dt=1;
    int tiempo=0;
    Thread hilo=null;
    DinamicaView dinamica;
    float s;

    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);


        dinamica=new DinamicaView(this);
        setContentView(dinamica);
        s=getResources().getDisplayMetrics().density;
        hilo = new Thread(dinamica);
        hilo.start();

    }

    // detenemos el hilo si pausa
    @Override
    public void onPause(){
        super.onPause();
        continuar=false;
    }

    // reiniciamos el hilo si resume
    @Override
    public void onResume(){
        super.onResume();

        continuar=true;
        if(!hilo.isAlive()){
            hilo=new Thread(dinamica);
            hilo.start();
        }

    }


    class DinamicaView extends View implements Runnable{

        int x,y,ymax;  // coordenadas
        Paint paintFondo,paintParticula,paint;
        public DinamicaView(Context context) {
            super(context);
            // Colores para el dibujo y tmaño del texto
            paintFondo=new Paint();
            paintParticula=new Paint();
            paint=new Paint();
            paintFondo.setColor(Color.WHITE);
            paintParticula.setColor(Color.RED);
            paint.setColor(Color.BLACK);
        }

        @Override
        public void run() {

            while(continuar){

                cambiaPosicion();
                postInvalidate();
                try { Thread.sleep( dt ); }
                catch ( InterruptedException e ){ ; }				}
        }


        public void cambiaPosicion() {

            tiempo=tiempo+dt;
            // fuerza v=v+a*dt
            velocidad=velocidad+aceleracion*dt;
            // conservacion de la energia
            float cinetica=velocidad*velocidad/2;
            y=(int)((cinetica-energia)/aceleracion);
            // si llega abajo invertimos velocidad
            if(y>ymax) velocidad=-Math.abs(velocidad);
            // si llega arriba invertimos velocidad
            if(y<0) velocidad=Math.abs(velocidad);
        }

        // obtiene geometria del canvas
        @Override
        protected void onSizeChanged(
                int w, int h, int oldw,int oldh){
            x=w/2;
            y=0;
            ymax=h;
            velocidad=0.05f*s;
            aceleracion=0.01f*s;
            energia=0.5f * velocidad * velocidad - aceleracion * y;
        }

        @Override
        public void onDraw(Canvas canvas ){
            canvas.drawPaint(paintFondo);
            paint.setTextSize(20*s);
            canvas.drawCircle(x, y, 30*s, paintParticula);
            canvas.drawText("y="+y, 10*s, 25*s, paint);
            canvas.drawText("t="+tiempo, 10*s, 50*s, paint);
            canvas.drawText("v="+velocidad, 10*s, 75*s, paint);
        }

    }   // fin dinamica
}
