package es.ugr.amaro.checkstorage;

import android.Manifest;
import android.content.pm.PackageManager;
import android.os.Environment;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;

public class MainActivity extends AppCompatActivity implements View.OnClickListener{

    final int MY_PERMISSIONS=1;
    TextView tv;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.milayout);
        tv = (TextView) findViewById(R.id.texto);
        Button button=findViewById(R.id.button);
        button.setOnClickListener(this);
    }  // ON CREATE

    public void onClick(View v) {

//        String[] permissions = new String[]{Manifest.permission.WRITE_EXTERNAL_STORAGE};
//        tv.append("\nPermiso:"+permissions[0]);

        ActivityCompat.requestPermissions(this,
                new String[]
                        {Manifest.permission.WRITE_EXTERNAL_STORAGE},
                MY_PERMISSIONS);
    }


    @Override
    public void onRequestPermissionsResult(int requestCode,
                                           String permissions[], int[] grantResults) {
        if (requestCode== MY_PERMISSIONS) {
                // Si no se autoriza, los arrays estarán vacíos
                if (grantResults.length > 0
                        && grantResults[0] == PackageManager.PERMISSION_GRANTED) {

                    // Permiso concedido. Llamada al método para escribir
                    tv.append("\nPermiso concedido para escribir\n");
                    tv.append(permissions[0]);
                    this.writeSD3();

                } else {
                    // Permiso denegado
                    tv.append("\n\n No permission given");
                }
            }
        }  // onRequestPermissionsResult

        void writeSD1() {

            String state = Environment.getExternalStorageState();
            tv.append("\nEstado:" + state);

            /* Comprueba si la memoria externa está montada  */
            if (Environment.MEDIA_MOUNTED.equals(state))
                tv.append("\nExternal storage Mounted");

            // Explorando el directorio raiz
            String rootPath = "/";
            File rootFile = new File(rootPath);
            String rootPath2 = rootFile.getAbsolutePath();
            tv.append("\nAbsolutePath=" + rootPath2);

            // Intenta crear un subdirectorio datos
            File datos = new File(rootFile, "datos");
            if (datos.mkdirs())
                tv.append("\nDirectorio creado" + datos.getAbsolutePath());
             else
                tv.append("\nNo se puede crear directorio");

            // Listado del directorio
            try {
                String[] listado = rootFile.list();
                int nfiles = listado.length;
                tv.append("\n no. files=" + nfiles);
                for (int i = 0; i < nfiles; i++) {
                    tv.append("\n" + listado[i]);
                }
            } catch (Exception e) {
                tv.append("Error:" + e);
            }
        }

/*  ---------------------------------------------------  */
        void writeSD2(){

        // Busca el directorio de almacenamiento externo
        String root= System.getenv("EXTERNAL_STORAGE");
        tv.append("\n\nEXTERNAL_STORAGE:"+root);

        File rootFile = new File(root);
        String rootPath = rootFile.getAbsolutePath();
        tv.append("\nAbsolutePath=" + rootPath);

        // Intenta crear un subdirectorio datos
        File datos = new File(rootFile, "datos");
        if (datos.mkdirs())
            tv.append("\nDirectorio creado" +
                    datos.getAbsolutePath());
        else
                tv.append("\nNo se puede crear directorio");

        try {
            String[] lista = rootFile.list();
            int nfiles = lista.length;
            tv.append("\n no. files=" + nfiles);
            for (int i = 0; i < nfiles; i++) {
                tv.append("\n" + lista[i]);
            }
        } catch (Exception e) {
            tv.append("Error:" + e);
        }

        try{

        File fichero=new File(datos,"datos1.txt");
            FileOutputStream fos = new FileOutputStream(fichero);
            PrintWriter pw= new PrintWriter(fos);
            pw.println("Primera linea del fichero");
            pw.println("Segunda linea del fichero");
            pw.flush();
            pw.close();
            tv.append("\n\n Fichero grabado");
        } catch (FileNotFoundException e){
            e.printStackTrace();
            tv.append("\n\n "+e);
        }

    }  // write SD


    void writeSD3(){
       /* Escribe en el almacenamiento externo compartido  */

        // Directorio público Documents del usuario
        File documents =
                Environment.getExternalStoragePublicDirectory(
                Environment.DIRECTORY_DOCUMENTS);
        tv.append("\n documents directory=" + documents);
        File mydocuments = new File(documents, "mydocuments");
        tv.append("\n\nDirectory to be created=" + mydocuments);
        if (mydocuments.exists())
            tv.append("\n\nFile already exists:"
                    + mydocuments.getAbsolutePath());
        else{
            if (mydocuments.mkdirs())
                tv.append("\n\nDirectorio creado:"
                        + mydocuments.getAbsolutePath());
            else
                tv.append("\n\nDirectorio no creado:"
                        + mydocuments.getAbsolutePath());
        }

        // Creamos un fichero de texto en el directorio mydocuments
        try{
            File fichero=new File(mydocuments,"datos1.txt");
            FileOutputStream fos = new FileOutputStream(fichero);
            PrintWriter pw= new PrintWriter(fos);
            pw.println("Primera linea del fichero");
            pw.println("Segunda linea del fichero");
            pw.flush();
            pw.close();
            tv.append("\n\n Fichero grabado");
        } catch (FileNotFoundException e){
            e.printStackTrace();
            tv.append("\n\n "+e);
        }
    }  // write SD3



    void writeSD(){

        String state = Environment.getExternalStorageState();
        tv.append("\nEstado:" + state);

        // requiere API level 21
//        File[] dirs= getExternalMediaDirs();

//            String root = "/storage/3535-6363";
        String root = "/storage/emulated/0";
        File rootFile = new File(root);
        String rootPath = rootFile.getAbsolutePath();
        tv.append("\nAbsolutePath=" + rootPath);
        File rootAbsolute = new File(root);
        try {
            String[] lista = rootAbsolute.list();
            int nfiles = lista.length;
            tv.append("\n no. files=" + nfiles);
            for (int i = 0; i < nfiles; i++) {
                tv.append("\n" + lista[i]);
            }
        } catch (Exception e) {
            tv.append("Error:" + e);
        }

        /* Checks if external storage is available for read and write */
        if (Environment.MEDIA_MOUNTED.equals(state))
            tv.append("\nExternal storage Mounted");

        /* Checks if external storage is available to at least read */
        if (Environment.MEDIA_MOUNTED.equals(state) ||
                Environment.MEDIA_MOUNTED_READ_ONLY.equals(state))
            tv.append("\nExternal storage read only");

        // Get the directory for the user's public pictures directory.
        File documents = Environment.getExternalStoragePublicDirectory(
                Environment.DIRECTORY_DOCUMENTS);
        tv.append("\n documents directory=" + documents);
        File file = new File(documents, "mydocuments");
        tv.append("\n\nDirectory to be created=" + file);
        if (file.exists())
            tv.append("\n\nFile already exists:" + file.getAbsolutePath());
        else{
            if (!file.mkdirs())
                tv.append("\n\nDirectory not created:" + file.getAbsolutePath());
        }

// busqueda de la tarjeta SD externa
        File externa1=Environment.getDataDirectory();
        tv.append("\nDataDirectory:"+externa1);
        File externa2=Environment.getRootDirectory();
        tv.append("\nRootDirectory:"+externa2);
        File externa3=Environment.getExternalStorageDirectory();
        tv.append("\nExternalStorageDirectory:"+externa3);


        String microSD= System.getenv("EXTERNAL_SDCARD_STORAGE");
        tv.append("\n\n SECONDARY_STORAGE:"+microSD);
        String extStore= System.getenv("EXTERNAL_STORAGE");
        tv.append("\n\nEXTERNAL_STORAGE:"+extStore);

        microSD="/storage/3535-6363";

        File sd_card = new File(microSD);
        File dir = new File(sd_card, "datos");
        try {
//            File root = Environment.getExternalStorageDirectory();
            dir.mkdirs();
            tv.append("\n\nNuevo directorio: " + dir);

            tv.append("\n\nContenido del directorio "+sd_card+" :");
            String[] fichero=sd_card.list();
            for(int i=0;i<fichero.length;i++) tv.append
                    ("\n"+fichero[i]);
        }catch(Exception e){
            tv.append("\n\n"+e);
        }

        try{

            File fichero=new File(dir,"datos1.txt");
            FileOutputStream fos = new FileOutputStream(fichero);
            PrintWriter pw= new PrintWriter(fos);
            pw.println("Primera linea del fichero");
            pw.flush();
            pw.close();
            tv.append("\n\n Fichero grabado");
        } catch (FileNotFoundException e){
            e.printStackTrace();
            tv.append("\n\n "+e);
        }

    }  // write SD
}



