package es.ugr.amaro.share;

import android.content.Intent;
import android.os.Bundle;
import android.support.v4.view.MenuItemCompat;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.ShareActionProvider;
import android.support.v7.widget.Toolbar;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.EditText;
import android.widget.TextView;

public class MainActivity extends AppCompatActivity implements TextWatcher{

    EditText miText;
    String mensaje="";
    TextView tv;
    Intent intent;
    ShareActionProvider saProvider;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.milayout);
        tv=findViewById(R.id.textview2);
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        miText= findViewById(R.id.editText);
        miText.addTextChangedListener(this);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Infla el menú
        getMenuInflater().inflate(R.menu.menu_main, menu);
        // Encuentra el MenuItem con el ShareActionProvider
        MenuItem shareItem = menu.findItem(R.id.share);
        // Obtiene su ShareActionProvider
        saProvider =  (ShareActionProvider) MenuItemCompat.getActionProvider(shareItem);
        // Construye el intent para compartir
        intent = new Intent();
        intent.setAction(Intent.ACTION_SEND);
        intent.setType("text/plain");
        intent.putExtra(Intent.EXTRA_TEXT, "Mensaje compartido con ShareActionProvider");
        // Asigna al ShareActionProvider su intent para compartir
        if (saProvider != null) {
            saProvider.setShareIntent(intent);
        }
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        int id = item.getItemId();

        if (id == R.id.item1) {
            tv.append("\nPulsado el item 1");
            return true;
        }
        if (id == R.id.item2) {
            tv.setText("");
            return true;
        }

        if (id == R.id.delete) {
            miText.setText("");
            tv.setText("Mensaje borrado");
            return true;
        }

        if (id==R.id.share){
            tv.append("\nPulsado el item share");
            intent.putExtra(Intent.EXTRA_TEXT, "Mensaje Modificado");
            saProvider.setShareIntent(intent);
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

    public void afterTextChanged(Editable s) {
        if (s.length() > 0) {
            mensaje= miText.getText().toString();
            intent.putExtra(Intent.EXTRA_TEXT, mensaje);
            saProvider.setShareIntent(intent);
            tv.setText(mensaje);
        }
    }

}

