package es.ugr.amaro.barradeprogreso;

import android.app.Dialog;
import android.app.ProgressDialog;
import android.os.Handler;
import android.os.Message;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

public class MainActivity extends AppCompatActivity
                    implements View.OnClickListener {


    ProgressDialog progreso;
    Controlador handler=new Controlador();
    int maximo=100;
    int delay=100;
    int id=1;
    int estilo=ProgressDialog.STYLE_HORIZONTAL;
    TextView texto;

    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.milyout);
        Button boton= (Button) findViewById(R.id.button1);
        boton.setOnClickListener(this);
        texto=(TextView) findViewById(R.id.texto);
    }

    @Override
    public void onClick(View v) {
        showDialog(id);
    }

    // Crea una barra de progeso
    @Override
    public Dialog onCreateDialog(int id) {

        progreso = new ProgressDialog(this);
        progreso.setProgressStyle(estilo);
        progreso.setMessage("");
        return progreso;
    }


    // Prepara la barra de progeso
    @Override
    public void onPrepareDialog(int id,Dialog dialog) {
        progreso=(ProgressDialog)dialog;
        progreso.setProgressStyle(estilo);
        progreso.setMax(maximo);
        progreso.setProgress(0);
        progreso.setMessage(
                "Ejecutando hilo en background...");
        Hilo thread=new Hilo();
        thread.start();
    }

    class Controlador extends Handler {
        @Override
        public void handleMessage(Message msg){
            int i=msg.getData().getInt("i");
            progreso.setProgress(i);
            progreso.setMessage("Hilo en background "+i+" Máximo: "+maximo);
            texto.setText(" i = "+i+" Maximo: "+maximo);
            if(i==maximo){
                dismissDialog(id);
            }
        }
    }

    class Hilo extends Thread{
        @Override
        public void run(){

            for (int i=0;i<=maximo;i++){
                try{
                    Thread.sleep(delay);
                } catch (InterruptedException e){;}
                Message msg=handler.obtainMessage();
                Bundle b =new Bundle();
                b.putInt("i",i);
                msg.setData(b);
                handler.sendMessage(msg);
            }
        }
    }

}
