package es.ugr.amaro.zipattach;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.zip.Deflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

public class ZipAttachActivity extends Activity 
                               implements OnClickListener{

	EditText et1,et2,et3;
	TextView tv;
	String filePath="";
	String tmpString;
	String zipString="";
	
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        Button boton= (Button) findViewById(R.id.button1);
        boton.setOnClickListener(this);
        et1=(EditText) findViewById(R.id.editText1);
        et2=(EditText) findViewById(R.id.editText2);
        et3=(EditText) findViewById(R.id.editText3);
        tv=(TextView) findViewById(R.id.textView);

        String[] ficheros={"fichero1.txt","fichero2.txt","fichero3.txt"};
        
        for(int i=0;i<ficheros.length;i++){
		writefile(ficheros[i]);
        }
        
        // nombre del fichero zip, conteniendo ruta
        zipString=tmpString+"/deflated.zip";
        writeZip(ficheros,zipString);
    }
    

	@Override
	public void onClick(View arg0) {
	
		// extrae direcciones en un array
		String direcciones=et1.getText().toString();
		StringTokenizer token=new StringTokenizer(direcciones);
		int n= token.countTokens();
		String[] to= new String[n];
		for(int i=0;i<n;i++) to[i]=token.nextToken();
		
		String subject=et2.getText().toString();
		String body=et3.getText().toString();
		
		Intent intent=new Intent(Intent.ACTION_SEND);
		intent.putExtra(Intent.EXTRA_EMAIL,to);
		intent.putExtra(Intent.EXTRA_SUBJECT, subject);
		intent.putExtra(Intent.EXTRA_TEXT, body);

		Uri uri=Uri.parse("file://"+zipString);
		tv.append("\nenviado attachment "+uri.toString());
		intent.putExtra(Intent.EXTRA_STREAM,uri);
		intent.setType("application/zip");
//		intent.setType("text/plain");
//		intent.setType("text/txt");
		startActivity(Intent.createChooser(intent, "Email"));
//		startActivity(intent);		
	}

	void writefile(String fileString){
		
		try{
		File root=Environment.getExternalStorageDirectory();
		String rootString= root.getAbsolutePath();
		tmpString=rootString+"/tmp";
		File tmp=new File(tmpString);
		tmp.mkdir();
		
		filePath=tmpString+"/"+fileString;

		File file=new File(tmp,fileString);
		if(file.exists()){
			tv.append("\nFichero ya existe"+filePath);
			
			
				FileOutputStream out=new FileOutputStream(file);
				PrintWriter writer= new PrintWriter(out);
				for(int i=0;i<2000;i++){
				writer.println("Este es el fichero adjunto");
				writer.println("que se va a enviar por email.");
				}
				writer.flush();
				writer.close();
				tv.append("\nFchero grabado"+filePath);
			
		}
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				tv.append("\nError:"+e);
			}	
		}
    
	void writeZip(String[] files, String zipFile){
		
		try{
		FileOutputStream out=new FileOutputStream(zipFile);
		BufferedOutputStream buffer=new BufferedOutputStream(out);
		ZipOutputStream zip=new ZipOutputStream(buffer);


		zip.setMethod(Deflater.DEFLATED);
		zip.setLevel(Deflater.BEST_COMPRESSION);
//		zip.setLevel(4);
//		zip.setLevel(Deflater.BEST_SPEED);
		
		// tamaño del buffer para leer Kbytes
		int size=1024;
		byte datos[]= new byte[size];
		int nfiles=files.length;
		for(int i=0;i<nfiles;i++){
			tv.append("\nZip "+files[i]);
			FileInputStream input=new FileInputStream(tmpString+"/"+files[i]);
			BufferedInputStream bufferInput=new BufferedInputStream(input);
			
			ZipEntry ze=new ZipEntry(files[i]);
			zip.putNextEntry(ze);
			int nbytes;
			// lee nbytes de datos del input y los adjunta al zip
			while((nbytes=bufferInput.read(datos,0,size)) !=-1){
				zip.write(datos,0,nbytes);				
			}
			bufferInput.close();			
		}
		zip.close();
		}catch(Exception e){
			tv.append("\nError en zip "+e);
		}
	}
}