package es.ugr.amaro.htmlview;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.Button;

public class HtmlViewActivity extends Activity implements OnClickListener{

	WebView webView1,webView2;
	String html1,html2;
	/** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
                
        Button boton=(Button) findViewById(R.id.button1);
        boton.setOnClickListener(this);

        webView1=(WebView) findViewById(R.id.webView1);
        webView2=(WebView) findViewById(R.id.webView2);

		WebSettings webSettings1= webView1.getSettings();
        webSettings1.setBuiltInZoomControls(true);
		WebSettings webSettings2= webView2.getSettings();
        webSettings2.setBuiltInZoomControls(true);
        webSettings2.setUseWideViewPort(true);
        // necesario para escribir acentos y otros caracteres
        webSettings1.setDefaultTextEncodingName("utf-8");
        
		html1="<h1>Mostrando imágenes locales</h1>"+
			   "<b>Ejemplo de uso de HTML en Android</b><br><hr>"+
			   "<center>"+
				"<font size=4 color=\"#880000\">Pulsar el botón "+
				"para cargar una imagen de la galería</font>"+
				"</center>";
		webView1.loadData(html1, "text/html", "utf-8");        
    }

	@Override
	public void onClick(View v) {
		// TODO Auto-generated method stub
		Intent intent=new Intent(Intent.ACTION_GET_CONTENT);
		intent.setType("image/*");
		startActivityForResult(intent,1);
	}
	
	@Override
	public void onActivityResult(int request,int result,Intent intent){

		try{
		Uri uri=intent.getData();
		String mime=getContentResolver().getType(uri);		
		//---cargar la imagen en html2---
        String html2="<img src="+uri.toString()+">";
        webView2.setInitialScale(25);
        webView2.loadData(html2,"text/html","utf-8");


		html1=html1+"Se ha cargado la imagen <br> <b>uri:</b>"+
		"<br>"+uri.toString()+
		"<br><b>mime:</b><br>"+mime;
		}
		catch(Exception e){
			html1=html1+"<font size=6 color=\"#000088\"><b>"+
			"No se ha podido cargar la imagen</b></font>";
		}
		
		webView1.loadData(html1, "text/html", "utf-8");		
        
	}
}