package es.ugr.amaro.basededatos;

import android.app.Activity;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.widget.TextView;

public class BaseDeDatosActivity extends Activity {
    
	TextView tv;
	String texto="";
    SQLiteDatabase db=null;
	Cursor cursor=null;    
	
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        tv= (TextView) findViewById(R.id.textView);        
        
        	//---abre o crea base de datos---        	
        	db=this.openOrCreateDatabase("musica.db",MODE_PRIVATE,null);

        	//---crea una tabla si no existe
        	db.execSQL("create table if not exists "+
        			" operas (id integer primary key, titulo text,"+
        			" compositor text, year integer);");

        	ejecutaSQL();
        	muestraTabla();
        	db.close(); 
	}

    void ejecutaSQL(){

    	//---inserta datos en la tabla---        	    	
//    	db.execSQL("insert into operas (titulo,compositor,year) "+
//		   " values('Don Govanni','W.A. Mozart',1787);");    

//      	for (int i=2; i<11; i++)
//    	db.execSQL("delete from operas where id="+i+";");      	

//       	db.execSQL("insert into operas (titulo,compositor,year) "+
//		   " values('Giulio Cesare','G.F. Haendel',1724);");    
//       	db.execSQL("insert into operas (titulo,compositor,year) "+
//		   " values('Orlando Furioso','A. Vivaldi',1727);");  
//       	db.execSQL("insert into operas (titulo,compositor,year) "+
//		   " values('Montezuma','C.H. Graun',1755);");    
//    	db.execSQL("insert into operas (titulo,compositor,year) "+
//		   " values('Statira','F. Cavalli',1656);");  
    	    	
       	//---selecciona todos los datos en un Cursor---  
    	cursor= db.rawQuery("select year, titulo, compositor from operas order by year",null);    	
    }  // end ejecutaSQL
    
    void muestraTabla(){
    	tv.append("\nTamaño: "+db.getPageSize());
    	int numeroDeColumnas=cursor.getColumnCount();
        tv.append("\nColumnas: "+numeroDeColumnas);
        int numeroDeFilas=cursor.getCount();
        tv.append("\nFilas: "+numeroDeFilas);

        texto=texto+"\n---------------------------\n";
        String[] columna= new String[numeroDeColumnas];
        for (int i=0 ; i<numeroDeColumnas ; i++){
        	columna[i]= cursor.getColumnName(i);
        	texto=texto+columna[i]+"  ";
        }     
        texto=texto+"\n---------------------------";
        
        cursor.moveToFirst();
    	String campo;
    	for (int i=1;i<=numeroDeFilas;i++){	
    		//---loop sobre las filas---

    			texto=texto+"\n";
    			for (int j=0; j<numeroDeColumnas;j++){
    				//---loop sobre las columnas---
    				campo=cursor.getString(j);
    				texto=texto + campo+ "  ";
    			} 			    			
    			cursor.moveToNext();    		
    	}   
    	tv.append(texto);     
    }  //  end muestraTabla
    
}