package es.ugr.amaro.listactivity;

import android.app.ListActivity;
import android.graphics.Color;
import android.os.Bundle;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.TextView;

public class ListActivityActivity extends ListActivity {
	
	String[] grupos,gruposPulsados;
	int[] pulsaciones;   // pulsaciones de cada item
    TextView tv;
    
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

    // inicializa varios arrays    
    grupos = getResources().getStringArray(R.array.grupos);
    int ngrupos=grupos.length;
    pulsaciones=new int[ngrupos];
    for(int i=0;i<ngrupos;i++)pulsaciones[i]=0;
    gruposPulsados=grupos.clone();
    
    // define propiedades del ListView
    ListView listView= getListView();
    listView.setBackgroundColor(Color.BLUE);
    listView.setDividerHeight(5);
    listView.setChoiceMode(1);  // modo de eleccion simple con marcas
    
    // define un TextView para el encabezamiento
    tv= new TextView(this);
    tv.setTextColor(Color.BLACK);
    tv.setTextSize(24);
    tv.setBackgroundColor(Color.rgb(250,230,160));
    tv.setText("Lista de Grupos");
    listView.addHeaderView(tv);
    
    // asocia un adaptador con un layout prefijado
    setListAdapter(new ArrayAdapter<String>(this,
    		       android.R.layout.simple_list_item_checked,gruposPulsados));    
    }
    
    public void onListItemClick(ListView parent, View v, int position, long id){

    	// indice del array pulsado (empieza en cero, por tanto restamos 1)
    	int index=position-1;
    	pulsaciones[index]=pulsaciones[index]+1;
    	gruposPulsados[index]=grupos[index]+" "+pulsaciones[index];
    	tv.setText("Seleccionado "+position+": "+grupos[index]);
    }
    
}