package es.ugr.amaro.mapcontrol;

import com.google.android.maps.GeoPoint;
import com.google.android.maps.MapActivity;
import com.google.android.maps.MapController;
import com.google.android.maps.MapView;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

public class MapControlActivity extends MapActivity 
                                implements OnClickListener{
	MapView mapView;
	MapController controller;
	boolean satellite=false;
	boolean streetView=false;
	boolean traffic=false;
	EditText editText1,editText2;
	TextView tv;
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        mapView=(MapView) findViewById(R.id.mapView);
        controller=mapView.getController();
        
        Button boton1=(Button) findViewById(R.id.buttonIn);
        Button boton2=(Button) findViewById(R.id.buttonOut);
        Button boton3=(Button) findViewById(R.id.buttonIr);
        Button boton4=(Button) findViewById(R.id.buttonSatelite);
        boton1.setOnClickListener(this);
        boton2.setOnClickListener(this);
        boton3.setOnClickListener(this);
        boton4.setOnClickListener(this);
        editText1=(EditText) findViewById(R.id.editText1);
        editText2=(EditText) findViewById(R.id.editText2);
        tv=(TextView) findViewById(R.id.textView);
    }

	@Override
	protected boolean isRouteDisplayed() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void onClick(View v) {
		// TODO Auto-generated method stub
		int id=v.getId();
		
		if(id==R.id.buttonIn){
			controller.zoomIn();
		}
		else if(id==R.id.buttonOut){
			controller.zoomOut();
		}
		else if(id==R.id.buttonSatelite){
			satellite=!satellite;
			mapView.setSatellite(satellite);
		}
		else if(id==R.id.buttonIr){
			String latitud=editText1.getText().toString();
			String longitud=editText2.getText().toString();
			try{
			int  lat=(int)( Double.parseDouble(latitud)*1E6);
			int  lon=(int)(Double.parseDouble(longitud)*1E6);
			GeoPoint geoPoint=new GeoPoint(lat,lon);
			controller.animateTo(geoPoint);
			controller.setZoom(12);
			mapView.invalidate();
			}catch(Exception e){
			  Toast.makeText(this,"Coordenadas inválidas",1).show();
			}
		}
		int zoom=mapView.getZoomLevel();
		tv.setText("Zoom: "+zoom);		
	}
}