package es.ugr.amaro.urimatcher;

import java.util.List;
import android.app.Activity;
import android.content.UriMatcher;
import android.net.Uri;
import android.os.Bundle;
import android.widget.TextView;

public class UriMatcherActivity extends Activity {
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        TextView tv=(TextView) findViewById(R.id.textView);
        
        String autoridad="es.ugr.amaro.content.operas";
        UriMatcher uriMatcher= new UriMatcher(UriMatcher.NO_MATCH);
        uriMatcher.addURI(autoridad,"operas",1);
        uriMatcher.addURI(autoridad,"operas/#",2);
        
        Uri uri1=Uri.parse("content://es.ugr.amaro.content.operas/operas");
        Uri uri2=Uri.parse("content://es.ugr.amaro.content.operas/operas/1");
        Uri uri3=Uri.parse("content://es.ugr.amaro.content.operas/operas/2");

        int match1=uriMatcher.match(uri1);
        int match2=uriMatcher.match(uri2);
        int match3=uriMatcher.match(uri3);
        
        tv.append("\n\n"+uri1+"\nuriMatcher codigo="+match1);
        tv.append("\n\n"+uri2+"\nuriMatcher codigo="+match2);
        tv.append("\n\n"+uri3+"\nuriMatcher codigo="+match3);    

        //---descompone un uri en segmentos---
        List<String> segmentos = uri3.getPathSegments();
        int size=segmentos.size();
        tv.append("\nNumero de segmentos="+size);

        String segmento;
        for(int i=0;i<size;i++){
        	segmento= segmentos.get(i);
        	tv.append("\nsegmento "+i+" = "+segmento);
        }       
    }
}