package es.ugr.amaro.listviewmulti;

import java.util.ArrayList;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.BaseAdapter;
import android.widget.ListView;
import android.widget.TextView;

public class ListViewMultiActivity extends Activity implements OnItemClickListener{

	ListView lv;
	TextView tv;
	/** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        String[] grupos= getResources().getStringArray(R.array.grupos);
        String[] miembros= getResources().getStringArray(R.array.miembros);
        String[] years= getResources().getStringArray(R.array.years);
        
        ArrayList<Grupo> gruposArrayList = new ArrayList<Grupo>();

        for(int i=0; i<grupos.length;i++){
        Grupo g1 = new Grupo();
        g1.nombre=grupos[i];
        g1.miembros=miembros[i];
        g1.years=years[i];
        gruposArrayList.add(g1);
        }
        
        tv= (TextView) findViewById(R.id.textView);
        lv=(ListView) findViewById(R.id.listView1);
        
        MiAdaptador adapter = new MiAdaptador(this,gruposArrayList);
        lv.setAdapter(adapter);      
        lv.setOnItemClickListener(this);
    }
    
    class MiAdaptador   extends BaseAdapter{

    	ArrayList<Grupo> grupoArrayList;
    	LayoutInflater lInflater;
	
    	MiAdaptador(Context context,ArrayList<Grupo> grupos){
    		grupoArrayList=grupos;
    		lInflater=LayoutInflater.from(context);
    	}
	
	
    	@Override
    	public int getCount() {
    		return grupoArrayList.size();
    	}

    	@Override
    	public Object getItem(int index) {
    		return grupoArrayList.get(index);
    	}

    	@Override
    	public long getItemId(int id) {
    		return id;
    	}

    	@Override
    	public View getView(int item, View view, ViewGroup parent) {
	
    	// infla el layout de cada item
    		view=lInflater.inflate(R.layout.fila, null);
		// referencia a los TextView 
    		TextView tvNombre=(TextView) view.findViewById(R.id.textView1);
    		TextView tvMiembros=(TextView) view.findViewById(R.id.textView2);
    		TextView tvYears=(TextView) view.findViewById(R.id.textView3);
		
    		tvNombre.setText(grupoArrayList.get(item).nombre);
    		tvMiembros.setText(grupoArrayList.get(item).miembros);
    		tvYears.setText(grupoArrayList.get(item).years);
		
    		return view;
	}
}
  
	class Grupo{
		String nombre;
		String miembros;
		String years;
	}

	@Override
	public void onItemClick(AdapterView<?> av, View v, int position, long id) {
		Grupo grupo= (Grupo) lv.getItemAtPosition(position);
		tv.setText("Seleccionado "+grupo.nombre);	
	}
}

