package es.ugr.amaro.telefonos;

import android.app.Activity;
import android.content.ContentResolver;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.provider.ContactsContract;
import android.provider.ContactsContract.CommonDataKinds.Phone;
import android.widget.TextView;

public class TelefonosActivity extends Activity {
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        TextView tv=(TextView) findViewById(R.id.textView);
        
        Uri uriData;
        uriData=ContactsContract.CommonDataKinds.Phone.CONTENT_URI;
        uriData=ContactsContract.Data.CONTENT_URI;

        tv.setText("URI de la tabla Data:\n"+uriData.toString());
        
        String colPhone=Phone.NUMBER;
        String colName=Phone.DISPLAY_NAME;
        String colMime=ContactsContract.Data.MIMETYPE;
        String colRaw=ContactsContract.Data.RAW_CONTACT_ID;
        
        ContentResolver resolver=getContentResolver();
        String where=null;
        // descomentar para buscar amaro
//        where=colName+ " like '%amaro%'"; 
        Cursor cursor=resolver.query(uriData, null, where, null, null);
        startManagingCursor(cursor);
                
        int ncolumnas=0;
        tv.append("\nColumnas:"+ncolumnas);        
        String[] columna=cursor.getColumnNames();
        ncolumnas=columna.length;
        tv.append("\ncolumnas="+ncolumnas);

        for(int i=1;i<ncolumnas;i++){
        	tv.append("\n"+i+" , "+columna[i]);
        }
        
        int iPhone=cursor.getColumnIndex(colPhone);
        int iName=cursor.getColumnIndex(colName);
        int iMime=cursor.getColumnIndex(colMime);
        int iRaw=cursor.getColumnIndex(colRaw);
        
        tv.append("\nRAW_CONTACT_ID\n"+colRaw+" : "+iRaw);
        tv.append("\nPhone.DISPLAY_NAME\n"+colName+" : "+iName);
        tv.append("\nPhone.NUMBER\n"+colPhone+":"+iPhone);
        tv.append("\nMIMETYPE\n"+colMime+" : "+iMime+"\n");
        int nfilas=cursor.getCount();
        String phone,name,mime,raw;
        cursor.moveToFirst();
        for(int i=1;i<nfilas;i++){
        	phone=cursor.getString(iPhone);
        	name=cursor.getString(iName);
        	mime=cursor.getString(iMime);
        	raw=cursor.getString(iRaw);
        	tv.append("\n* "+raw+"\n"+name+"\n"+phone+"\n"+mime+"\n");
        	cursor.moveToNext();
        }        
        stopManagingCursor(cursor);
    }
}