package es.ugr.amaro.operas;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.AlertDialog.Builder;
import android.app.Dialog;
import android.content.DialogInterface;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemLongClickListener;
import android.widget.ListView;
import android.widget.SimpleCursorAdapter;
import android.widget.TextView;

public class OperasActivity extends Activity implements OnItemLongClickListener{
    /** Called when the activity is first created. */

    Uri uri=Uri.parse("content://es.ugr.amaro.provider.operas/operas");
	TextView tv;
	ListView lv;
	long id_borrar=-1;

	@Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        tv=(TextView) findViewById(R.id.textView);
        lv=(ListView) findViewById(R.id.listView1);
        
        mostrarTabla();
    }

	void mostrarTabla(){

        Cursor cursor=getContentResolver().query(uri, null, null, null, null);
        String[] from={"Titulo","Compositor","year"};
        int[] to={R.id.textView1,R.id.textView2,R.id.textView3};
        SimpleCursorAdapter adapter=new SimpleCursorAdapter(this, 
        		                          R.layout.fila, cursor, from, to);
        lv.setAdapter(adapter);
        lv.setOnItemLongClickListener(this);
	}
	
	@Override
	public boolean onItemLongClick(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
		// TODO Auto-generated method stub

		tv.setText("Seleccionado elemento "+arg2);
		id_borrar=arg3;
		showDialog(0);
		return false;
		
	}
	
	@Override
	protected Dialog onCreateDialog(int id){
		
		DListener listener=new DListener();
		Dialog dialogo=null;
		Builder builder=new AlertDialog.Builder(this);
		builder.setTitle("Borrar elemento");
		builder.setMessage("Está seguro? ");
		builder.setPositiveButton("Borrar", listener);
		builder.setNegativeButton("Cancelar", listener);
		dialogo=builder.create();
		return dialogo;
		
	}
	
	class DListener implements DialogInterface.OnClickListener{

		@Override
		public void onClick(DialogInterface dialog, int which) {
			// TODO Auto-generated method stub
			if(which==DialogInterface.BUTTON_POSITIVE){
				getContentResolver().delete(uri, "_id="+id_borrar,null);
			    mostrarTabla();
			}
		
		}
		
	}
	
}