package es.ugr.amaro.grupodeactividades;

import android.app.Activity;
import android.app.ActivityGroup;
import android.app.LocalActivityManager;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.Window;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;

public class GrupoDeActividadesActivity extends ActivityGroup 
                                        implements OnClickListener{

	Window window;
    LocalActivityManager manager;
    Intent intent;
    int id=0;
    TextView tv;
    LinearLayout ll;
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        ll=(LinearLayout) findViewById(R.id.layout);

        tv=(TextView) findViewById(R.id.textView);
        Button boton=(Button) findViewById(R.id.button);
        boton.setOnClickListener(this);
        manager=getLocalActivityManager();     
    }
    
	@Override
	public void onClick(View v) {
		id++;
		String idString=""+id;
		tv.setText("Iniciada actividad "+id);
		intent=new Intent(this,Actividad1.class);
		intent.putExtra("idString", idString);
        window = manager.startActivity(idString, intent);
        View view=window.getDecorView(); 
        ll.addView(view);   
	}
	
    @Override 
    public void finishFromChild(Activity child){

    	String idString=child.getIntent().getStringExtra("idString");
    	tv.setText("eliminada actividad "+idString);    	
    	Window ventana=child.getWindow();
    	View vista=ventana.getDecorView();
    	ll.removeView(vista);    	    	
    }
    
}