package es.ugr.amaro.addcontact;

import android.app.Activity;
import android.content.ContentUris;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.provider.ContactsContract;
import android.provider.ContactsContract.CommonDataKinds.Email;
import android.provider.ContactsContract.CommonDataKinds.Phone;
import android.provider.ContactsContract.CommonDataKinds.StructuredName;
import android.provider.ContactsContract.Data;
import android.provider.ContactsContract.RawContacts;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

public class AddContactActivity extends Activity implements OnClickListener{
    /** Called when the activity is first created. */
	TextView tv;
	EditText edit1,edit2,edit3,edit4;
	
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        tv=(TextView) findViewById(R.id.textView);
        edit1=(EditText) findViewById(R.id.editText1);
        edit2=(EditText) findViewById(R.id.editText2);
        edit3=(EditText) findViewById(R.id.editText3);
        edit4=(EditText) findViewById(R.id.editText4); 
        Button boton1=(Button) findViewById(R.id.button1);
        boton1.setOnClickListener(this);        
    }

	@Override
	public void onClick(View v) {

		String nombre=edit1.getText().toString().trim();
		String movil =edit2.getText().toString().trim();
		String casa  =edit3.getText().toString().trim();
		String email =edit4.getText().toString().trim();

		// ---esconde el teclado o SoftInput, se suele quedar desplegado--- 
		InputMethodManager manager=
		(InputMethodManager) this.getSystemService(INPUT_METHOD_SERVICE);
		manager.hideSoftInputFromWindow(v.getWindowToken(), 0);		

		tv.setText("Insertando contacto "+nombre+", "+movil+", "+casa+", "+email);		
		inserta(nombre,movil,casa,email);
		edit1.setText("");
		edit2.setText("");
		edit3.setText("");
		edit4.setText("");
		
	}
	
	public void inserta(String nombre,String movil,String casa, String email){
		

        ContentValues values=new ContentValues();
        long rawContactId=0;
        Uri uriRaw=ContactsContract.RawContacts.CONTENT_URI;
	    Uri uriData=ContactsContract.Data.CONTENT_URI;        
        
        // inserta raw_contact
		if(nombre.length()>0){
			
        // tipo de cuenta de telefonos
        String accountType="vnd.sec.contact.phone";
        accountType=null;
        values.clear();
        values.put(RawContacts.ACCOUNT_TYPE, accountType);
        values.put(RawContacts.ACCOUNT_NAME, accountType);
        Uri uriRawItem = getContentResolver().insert(uriRaw, values);
        rawContactId = ContentUris.parseId(uriRawItem);
        tv.append("\n\n*Paso 1...\nInsertado nuevo RAW_CONTACT");
        muestraRegistro(uriRawItem);
		}

		// inserta nombre
		if(nombre.length()>0 && rawContactId !=0){

        values.clear();
        values.put(ContactsContract.Data.RAW_CONTACT_ID, rawContactId);
        values.put(Data.MIMETYPE, StructuredName.CONTENT_ITEM_TYPE);
        values.put(StructuredName.DISPLAY_NAME,nombre);
        Uri uriNombre= getContentResolver().insert(uriData, values);        
        tv.append("\n\n**Paso 2...\nInsertado nombre del contacto");        
        muestraRegistro(uriNombre);
        }
				
		// inserta telefono movil
		if(movil.length()>0 && rawContactId !=0){
        values.clear();
        values.put(ContactsContract.Data.RAW_CONTACT_ID, rawContactId);
        values.put(ContactsContract.Data.MIMETYPE, Phone.CONTENT_ITEM_TYPE);
        values.put(Phone.NUMBER, movil);
        values.put(Phone.TYPE, Phone.TYPE_MOBILE);        
        Uri uriMovil= getContentResolver().insert(uriData, values);
        tv.append("\n\n***Paso 3...\nInsertado telefono movil");
        muestraRegistro(uriMovil);
		}		

		// inserta telefono de domicilio
		if(casa.length()>0 && rawContactId !=0){
	        values.clear();
	        values.put(ContactsContract.Data.RAW_CONTACT_ID, rawContactId);
	        values.put(ContactsContract.Data.MIMETYPE, Phone.CONTENT_ITEM_TYPE);
	        values.put(Phone.NUMBER, casa);
	        values.put(Phone.TYPE, Phone.TYPE_HOME);        
	        Uri uriCasa= getContentResolver().insert(uriData, values);
	        tv.append("\n\n****Paso 4...\nInsertado telefono del domicilio");
	        muestraRegistro(uriCasa);
			}		

		// inserta email
		if(email.length()>0 && rawContactId !=0){
	        values.clear();
	        values.put(ContactsContract.Data.RAW_CONTACT_ID, rawContactId);
	        values.put(ContactsContract.Data.MIMETYPE,Email.CONTENT_ITEM_TYPE);
	        values.put(Data.DATA1, email);
	        Uri uriEmail= getContentResolver().insert(uriData, values);
	        tv.append("\n\n****Paso 5...\nInsertado email");
	        muestraRegistro(uriEmail);
			}		

	} //---end inserta 

	void muestraRegistro(Uri uri) {

		tv.append("\n\n Mostrando registros no nulos del URI:\n"+uri);      
        Cursor cursor=getContentResolver().query(uri,null,null,null,null);

        String[] columnas1=cursor.getColumnNames();
        int ncolumnas=columnas1.length;
        cursor.moveToFirst();
        for(int i=0;i<ncolumnas;i++){
        	String columna=cursor.getString(i);
        	if(columna != null)
        	tv.append("\n"+i+":"+columnas1[i]+"="+cursor.getString(i));
        }		
	}  //--- end muestraRegistro	
}