package es.ugr.amaro.listviewlayout;

import java.util.ArrayList;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ListView;
import android.widget.TextView;

public class ListViewLayoutActivity extends Activity implements OnClickListener{

	TextView tv;
	EditText editText;
    ArrayAdapter<String> adapter;
	/** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        String[] grupos= getResources().getStringArray(R.array.grupos);
        ArrayList<String> arrayList=new ArrayList<String>();
        for(int i=0;i< grupos.length;i++)
        	arrayList.add(grupos[i]);
        
        tv=(TextView) findViewById(R.id.textView);
        editText=(EditText) findViewById(R.id.editText1);
        Button boton=(Button) findViewById(R.id.button1);
        boton.setOnClickListener(this);
        ListView lista= (ListView) findViewById(R.id.listView1);
        adapter =new ArrayAdapter<String>(this,R.layout.items,R.id.textItem2,arrayList);
        lista.setAdapter(adapter);
      
    }
	@Override
	public void onClick(View v) {
		// TODO Auto-generated method stub
		String grupo= editText.getText().toString();
		tv.setText("Añadiendo el grupo "+grupo);
		if(grupo.trim().length()==0) 
			tv.setText("Grupo invalido");
		else{
//			adapter.add(grupo);
			adapter.insert(grupo, 0);
			adapter.notifyDataSetChanged();
			tv.setText("Se ha añadido el grupo "+grupo);
			editText.setText("");
		}
	}
}