package es.ugr.amaro.location;

import com.google.android.maps.GeoPoint;
import com.google.android.maps.MapActivity;
import com.google.android.maps.MapController;
import com.google.android.maps.MapView;
import android.content.Context;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.location.LocationProvider;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.Window;
import android.widget.Button;
import android.widget.TextView;

public class LocationActivity extends MapActivity 
                              implements LocationListener, OnClickListener{
	
	LocationManager locationManager;
	int minTime=60000;
	int minDistance=1;
	String provider1=LocationManager.GPS_PROVIDER;
	String provider2=LocationManager.NETWORK_PROVIDER;
	String provider;
	MapView mapView;
	MapController mapControl;
	TextView tv,tv1;
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        setContentView(R.layout.main);
        tv=(TextView) findViewById(R.id.textView);
        tv1=(TextView) findViewById(R.id.textView1);
        
        Button boton1=(Button) findViewById(R.id.button1);
        Button boton2=(Button) findViewById(R.id.button2);
        Button boton3=(Button) findViewById(R.id.button3);
        boton1.setOnClickListener(this);
        boton2.setOnClickListener(this);
        boton3.setOnClickListener(this);

        // Invoca el servicio de localización y 
        // obtiene el nombre del mejor proveedor
		locationManager = (LocationManager) getSystemService(Context.LOCATION_SERVICE);	
		provider=provider2;
		
		// el mapa
		mapView = (MapView) findViewById(R.id.mapView);
		mapView.setSatellite(true);
		mapView.setBuiltInZoomControls(true);
		int maxzoom= mapView.getMaxZoomLevel();
		int initZoom=(int) (0.95*maxzoom);
		mapControl=mapView.getController();
		mapControl.setZoom(initZoom);		
    }
    
    void localiza(){
    	Location location=locationManager.getLastKnownLocation(provider);
    	if(location!=null){
    		tv.append("\nProvider: "+provider);
    		double latitud=location.getLatitude();
    		double longitud=location.getLongitude();
    		tv.append("\nLatitud: "+latitud);
    		tv.append("\nLongitud: "+longitud);
    		int latE6=(int)(latitud*1e6);
    		int lonE6=(int)(longitud*1e6);
    		GeoPoint geoPoint=new GeoPoint(latE6,lonE6);
    		mapControl.animateTo(geoPoint);
    		mapView.invalidate();
    	}
    }
    
    @Override
    public void onResume(){
    	super.onResume();
    	locationManager.requestLocationUpdates(provider, minTime, minDistance, this);
		localiza();
    }
    
    @Override
    public void onPause(){
    	super.onPause();
    	locationManager.removeUpdates(this);
    }

	@Override
	protected boolean isRouteDisplayed() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void onLocationChanged(Location location) {
		// TODO Auto-generated method stub
		tv.append("\nLocation changed");
		localiza();
	}

	@Override
	public void onProviderDisabled(String provider) {
		locationManager.removeUpdates(this);
		
	}

	@Override
	public void onProviderEnabled(String provider) {
    	locationManager.requestLocationUpdates(provider, minTime, minDistance, this);		
    	localiza();
	}

	@Override
	public void onStatusChanged(String provider, int status, Bundle extras) {
		// TODO Auto-generated method stub
		if(status==LocationProvider.AVAILABLE)
			tv.append("\nStatus changed: AVAILABLE");
		if(status==LocationProvider.OUT_OF_SERVICE)
			tv.append("\nStatus changed: OUT OF SERVICE");
		if(status==LocationProvider.TEMPORARILY_UNAVAILABLE)
			tv.append("\nStatus changed: TEMPORARILY UNAVAILABLE");
		
	}

	@Override
	public void onClick(View v) {
		// TODO Auto-generated method stub
		int id=v.getId();
		if(id==R.id.button1)
			provider=provider1;
		else if(id==R.id.button2)
			provider=provider2;
		else{
			Criteria criteria=new Criteria();
			provider=locationManager.getBestProvider(criteria, true);
		}
		LocationProvider locationProvider=locationManager.getProvider(provider);
		tv.append("\nProvider Accuracy= "+locationProvider.getAccuracy());
		tv1.setText(provider);
    	locationManager.requestLocationUpdates(provider, minTime, minDistance, this);
		localiza();
	}
}