package es.ugr.amaro.rawcontacts;

import android.app.Activity;
import android.content.ContentResolver;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.provider.ContactsContract;
import android.widget.TextView;

public class RawContactsActivity extends Activity {
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        TextView tv=(TextView) findViewById(R.id.textView);
        
        Uri uriRaw;
        uriRaw=ContactsContract.RawContacts.CONTENT_URI;
        tv.setText("Tabla RawContacts URI:\n"+uriRaw.toString());
        
        ContentResolver resolver=getContentResolver();
        Cursor cursor=resolver.query(uriRaw, null, null, null, null);
        
        //---muestra los nombres de las columnas en pantalla---
        String[] columna=cursor.getColumnNames();
        int ncolumnas=columna.length;        
        for(int i=0;i<ncolumnas;i++){
        	tv.append("\n"+i+" : "+columna[i]);
        }
        
        //---muestra los contenidos de las columnas
        String contactId=ContactsContract.RawContacts.CONTACT_ID;
        String accountName=ContactsContract.RawContacts.ACCOUNT_NAME;
        String accountType=ContactsContract.RawContacts.ACCOUNT_TYPE;
        int iId=cursor.getColumnIndex(contactId);
        int iName=cursor.getColumnIndex(accountName);
        int iType=cursor.getColumnIndex(accountType);
        cursor.moveToFirst();
        String id,name,type;
        int nfilas=cursor.getCount();
        for(int i=0;i<nfilas;i++){
        	id=cursor.getString(iId);
        	name=cursor.getString(iName);
        	type=cursor.getString(iType);
        	tv.append("\n"+id+"\n"+name+"\n"+type);
        	cursor.moveToNext();
        }
    }
}