package es.ugr.amaro.operasprovider;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

public class OperasProviderActivity extends Activity implements OnClickListener{
    /** Called when the activity is first created. */
	EditText et1,et2,et3;
	String compositor,titulo,year;
	Uri uri=Uri.parse("content://es.ugr.amaro.provider.operas/operas");
	TextView tv;
	@Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        tv=(TextView) findViewById(R.id.textView);
        
        Button boton=(Button) findViewById(R.id.button1);
        boton.setOnClickListener(this);
        tv.setText("");
        showTable();
//        showDatabase();
        
    }

	@Override
	public void onClick(View v) {
		// TODO Auto-generated method stub
		
		
        et1=(EditText) findViewById(R.id.editText1);
        et2=(EditText) findViewById(R.id.editText2);
        et3=(EditText) findViewById(R.id.editText3);
        compositor =et1.getText().toString();
		titulo=et2.getText().toString();
		year=et3.getText().toString();

		int lon1=compositor.length();
		int lon2=titulo.length();
		if(lon1*lon2 >0){
		ContentValues values=new ContentValues();
		values.put("compositor",compositor);
		values.put("titulo", titulo);
		values.put("year", year);
		Uri urinew=getContentResolver().insert(uri, values);
		tv.setText("Insertado uri="+urinew);
		tv.append("\n"+compositor+" "+titulo+" "+year);
		showTable();
		
		et1.setText("");
		et2.setText("");
		et3.setText("");
		
		// ---esconde el teclado o SoftInput, se suele quedar desplegado
		InputMethodManager manager=(InputMethodManager)
		this.getSystemService(INPUT_METHOD_SERVICE);
		manager.hideSoftInputFromWindow(v.getWindowToken(), 0);

		}else
		Toast.makeText(this,"Debe insertar compositor y título", 0).show();		
		
	}
	
	void showDatabase(){
        ContentResolver resolver=getContentResolver();
	}
	
	
	void showTable(){
		
        String mime = getContentResolver().getType(uri);
        tv.append("\nTipo="+mime);
		
        Cursor cursor = getContentResolver().query(uri,null,null,null,null);
        String[] columnas=cursor.getColumnNames();
        int ncolumnas=columnas.length;
        tv.append("\nTabla de operas, columnas="+ncolumnas);
        int nfilas=cursor.getCount();
        tv.append(", filas="+nfilas);
        if(nfilas>0){
        	
        	cursor.moveToFirst();
        	String id,compositor,titulo,year;
        	for (int i=0;i<nfilas;i++){
        		id=cursor.getString(0);
        		compositor=cursor.getString(1);
        		titulo=cursor.getString(2);
        		year=cursor.getString(3);
        		tv.append("\n"+id+" : "+compositor+" : "+titulo+" : "+year);
        		cursor.moveToNext();
        	}
        }
	}
	
}