package es.ugr.amaro.parsehtml;

import java.io.IOException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import android.app.Activity;
import android.os.AsyncTask;
import android.os.Bundle;
import android.widget.TextView;

public class ParseHTMLActivity extends Activity {
    /** Called when the activity is first created. */

	TextView tv;
	@Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        tv= (TextView) findViewById(R.id.textView);
        new MiAsyncTask().execute();
    }
    
    class MiAsyncTask extends AsyncTask<Void,String,Void>{
    	
    	@Override
    	protected Void doInBackground(Void...arg0){
    	
    	String baseUrl="http://www.aemet.es";
    	String url=baseUrl+"/es/eltiempo/prediccion/provincias";
        String dirProvincia="",provincia="",urlDato="";
        try {
        	publishProgress("Conectando a "+url);
			Document doc=Jsoup.connect(url).get();
			publishProgress("CONECTADO");
			String title=doc.title();
			publishProgress("Title:"+title);
	
			Elements elements;
			elements=doc.select("ul.oculta_enlaces");
			int n=elements.size();
			publishProgress("Encontrados elementos: "+n);

			Element element=elements.get(0);
			elements=element.select("a[href]");
			int links=elements.size();
			publishProgress("Links totales="+links);	

//			links=9; // hasta Barcelona
			for(int i=0;i<links;i++){
				Element eleProvincia=elements.get(i);
				dirProvincia=eleProvincia.attr("href");
				provincia=eleProvincia.text();
					urlDato=baseUrl+dirProvincia;						
		        	publishProgress("\n"+provincia+":\n"+urlDato);
					extraeDatos(urlDato);					
			}					
						
		} catch (IOException e) {
			// TODO Auto-generated catch block
		   publishProgress("Error "+e);
		}
		return null;        
    }

    	void extraeDatos(String urlDato){

			Document doc;
			try {
				doc = Jsoup.connect(urlDato).get();
				publishProgress("CONECTADO");
				// extrae texto <div class="notas_tabla>
				Elements elements= doc.select("div.contenedor_central");
				Element contenedor=elements.get(0);
				
				// selecciona <div class="notas_tabla> y extrae texto
				elements=contenedor.select("div.notas_tabla");
				Element notas=elements.get(0);
				publishProgress(notas.text());
				
				// extrae texto  <div class="contenedor_central">
				elements= doc.select("div.contenedor_central div.texto_normal");
				Element texto =elements.get(0);
				publishProgress(texto.text());
				
				// selecciona tabla
				elements=contenedor.select("table");
				publishProgress("Tablas encontradas:"+elements.size());
				Element tabla=elements.get(0);
				
				// selecciona filas de la tabla de ciudades
				Elements filas=tabla.select("tr");
				int nfilas=filas.size();
				publishProgress("Numero de ciudades:"+nfilas);
				for(int i=0;i<nfilas;i++){
					Element fila=filas.get(i);
					publishProgress(fila.text());
					
				}
				

				
				
	    		
			} catch (Exception e) {
				// TODO Auto-generated catch block
				publishProgress("error"+e);				
			}
    	}
    	
    	@Override
    	protected void onProgressUpdate(String... progress){
    		
    		String texto=progress[0];
    		tv.append("\n"+texto);    		
    	}
    
    	@Override
    	protected void onPostExecute(Void result){
    		tv.append("\nTask terminado");

    	}
    }  //---end AsyncTask
}