package es.ugr.amaro.geocoder;

import java.util.Iterator;
import java.util.List;
import com.google.android.maps.GeoPoint;
import com.google.android.maps.MapActivity;
import com.google.android.maps.MapController;
import com.google.android.maps.MapView;
import android.location.Address;
import android.location.Geocoder;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

public class GeocoderActivity extends MapActivity 
              implements OnClickListener, OnItemSelectedListener{
	
	EditText editText;
	Spinner spinner;
	int nmax=20;
	int resource=android.R.layout.simple_spinner_item;
	ArrayAdapter<String> adapter;
	String[] spinnerArray;
	String[] result=new String[nmax];
	double[] latitud=new double[nmax];
	double[] longitud=new double[nmax];
	MapView mapView;
	MapController mapController;
	TextView tv;
	
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        tv=(TextView) findViewById(R.id.textView);
        editText=(EditText) findViewById(R.id.editText1);
        Button boton=(Button) findViewById(R.id.button1);
        boton.setOnClickListener(this);

        // inicializa el spinner
        spinner=(Spinner) findViewById(R.id.spinner1);
        spinner.setPrompt("Mostrar mapa");
        spinnerArray=new String[1];
        spinnerArray[0]="Isla Elephanta Bombay, India";
        adapter=new ArrayAdapter<String>(this,resource,spinnerArray);
        spinner.setAdapter(adapter);
        spinner.setOnItemSelectedListener(this);

        // inicializa el mapa
        latitud[0]=18.963223;
        longitud[0]=72.9314073;
        mapView =(MapView) findViewById(R.id.mapView);
        mapView.setBuiltInZoomControls(true);
        mapController=mapView.getController();
        mapController.setZoom(3);
    }

	@Override
	public void onClick(View v) {
		
		try{
		String busqueda=editText.getText().toString();
		Geocoder geocoder=new Geocoder(this);
		
		List<Address> list=geocoder.getFromLocationName(busqueda,nmax);
		Iterator <Address> iterator= list.iterator();
		int n=0;
		
		String country;
		Address address;
		while(iterator.hasNext()){
			address=iterator.next();
			latitud[n]=address.getLatitude();
			longitud[n]=address.getLongitude();
			country=address.getCountryName();
			result[n]=address.getAddressLine(0)
			          +" "+address.getAddressLine(1)
			          +" "+country;
			n++;
		}
		spinnerArray=new String[n];
		for(int i=0;i<n;i++){
			spinnerArray[i]=result[i];
		}
		
		
		adapter=new ArrayAdapter<String>(this,resource,spinnerArray);
		spinner.setAdapter(adapter);
		
		}catch(Exception e){
			Toast.makeText(this, "Error en la busqueda", 1).show();
		}				
	}

	@Override
	protected boolean isRouteDisplayed() {
		return false;
	}

	@Override
	public void onItemSelected(AdapterView<?> arg0, View arg1, int arg2,
			long arg3) {
		
		int lat=(int) (latitud[arg2]*1e6);
		int lon=(int) (longitud[arg2]*1e6);
		mapController.setZoom(16);
		mapController.animateTo(new GeoPoint(lat,lon));
		mapView.setSatellite(true);
		mapView.invalidate();
		tv.setText(spinnerArray[arg2]);
		tv.append("\n"+latitud[arg2]+","+longitud[arg2]);
	}

	@Override
	public void onNothingSelected(AdapterView<?> arg0) {
	}
}