package es.ugr.amaro.cursoradapter;

import android.app.Activity;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.ListView;
import android.widget.SimpleCursorAdapter;
import android.widget.TextView;

public class CursorAdapterActivity extends Activity 
                                 implements OnItemClickListener{
	SQLiteDatabase db;
	TextView tv1,tv2;
	
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        tv1=(TextView) findViewById(R.id.textView1);
        tv2=(TextView) findViewById(R.id.textView2);
        
        db=openOrCreateDatabase("musica.db",MODE_PRIVATE,null);
        db.execSQL("create table if not exists operas1 " +
        		"(_id integer primary key, titulo text, " +
                 "compositor text, year integer);");
        // ---llena la tabla de operas
        //        llenaTabla();
        db.delete("operas1","_id>12", null);                 

        // ---Realiza una busqueda
        String[] columns={"_id","titulo","compositor","year"};
        Cursor cursor=db.query("operas1", columns,null,null,null,null,null);        
        // ---adapta el cursor a nuestro ListView
        ListView lv=(ListView) findViewById(R.id.listView1);
        String[] from={"titulo","compositor"};
        int[] to={R.id.textView3,R.id.textView4};
        SimpleCursorAdapter adapter=new SimpleCursorAdapter
                                 (this,R.layout.list, cursor, from,to);
        lv.setAdapter(adapter);
        lv.setOnItemClickListener(this);
        db.close();                                                                        
    }

    void llenaTabla(){

       insertaFila("Don Giovanni", "W. A. Mozart", 1787);
	   insertaFila("Giulio Cesare","G.F. Haendel",1724);    
	   insertaFila("Orlando Furioso","A. Vivaldi",1727);  
	   insertaFila("Montezuma","C.H. Graun",1755);
	   insertaFila("Statira","F. Cavalli",1656);  
	   insertaFila("La Griselda","A. Scarlatti",1721);
	   insertaFila("Il re Teodoro in Venezia","G. Paisiello",1784);
	   insertaFila("La Locandiera","A. Salieri",1773);
	   insertaFila("La Clementina","L. Boccherini",1783);
	   insertaFila("Il Matrimonio Segreto","D. Cimarosa",1792);
	   insertaFila("Il barbiere di Siviglia","G. Paisiello",1782);
	   insertaFila("Semiramide","G. Rossini",1823);
 	
    }
    
    void insertaFila(String titulo,String compositor, int year){
    	
    	ContentValues values=new ContentValues();
    	values.put("titulo",titulo);
    	values.put("compositor", compositor);
    	values.put("year", year);
    	db.insert("operas1",null, values);
    }
    

	@Override
	public void onItemClick(AdapterView<?> listView, View v, int position, long id) {
		// TODO Auto-generated method stub
		Cursor cursor=(Cursor) listView.getItemAtPosition(position);
		int _id=cursor.getInt(0);
		String titulo=cursor.getString(1);
		String compositor=cursor.getString(2);
		int year=cursor.getInt(3);
		tv1.setText(_id+", "+titulo);
		tv2.setText(compositor+", Estreno: "+year);
	}
    

}