############
#GetHaplo
############
GetHaplo<-function(readfile=T,input=NA,align=NA,saveFile=T,outname="Haplotypes.txt",format="fasta",seqsNames=NA)
{
if(readfile==T)
align<-read.dna(file=input,format="fasta")
mat_alin<-as.matrix(as.character(align))
FH<-FindHaplo(readfile=readfile,input=input,align=align,saveFile=saveFile,outname=outname)
Huniques<-c()
U<-unique(FH[,2])
for(i in 1:length(U))
Huniques<-c(Huniques,which(FH[,2]==U[i])[[1]])
out<-align[Huniques,]

if(is.na(seqsNames[1])==F)
{
if(seqsNames[1]=="Inf.Hap")
dimnames(out)[[1]]<-U
if(seqsNames[1]!="Inf.Hap")
dimnames(out)[[1]]<-seqsNames
}

if(saveFile==T)
write.dna(out,file=outname,format=format)

print(paste(length(U)," different haplotypes found",ifelse(saveFile==T, {paste(", and saved in the file: \"",outname,"\"",sep="")},{paste(", but not saved in any file",sep="")}),sep=""),quote=F)


out

}
############
#nt.gap.comb
############

nt.gap.comb<-function(DISTnuc=NA,DISTgap=NA,range=seq(0,1,0.1),method="Corrected",saveFile=TRUE)
{
library(ape)

CORnuc<-DISTnuc/(max(DISTnuc))
CORgap<-DISTgap/(max(DISTgap))

OUTuncor<-list(c())
OUTcor<-list(c())

if(method=="Uncorrected"|method=="Both")
{
	for(ite1 in 1:length(range))
	{
	alfa<-range[ite1]
	DIST<-(1-alfa)*DISTnuc+alfa*DISTgap
	if(saveFile==T)
	write.table(DIST,file=paste	("DistanceMatrixUncorrectedAlfa",alfa,sep="_"))
	OUTuncor[[ite1]]<-DIST
	}
}

if(method=="Corrected"|method=="Both")
{
	for(ite1 in 1:length(range))
	{
	alfa<-range[ite1]
	COR<-(1-alfa)*CORnuc+alfa*CORgap
	if(saveFile==T)
	write.table(COR,file=paste("DistanceMatrixCorregidaAlfa",alfa,sep="_"))
	OUTcor[[ite1]]<-COR
	}
}

if(method=="Uncorrected"|method=="Both")
names(OUTuncor)<-paste("Alpha=",range)

if(method=="Corrected"|method=="Both")
names(OUTcor)<-paste("Alpha=",range)

OUT<-list(OUTuncor,OUTcor)
names(OUT)<-c("Uncorrected","Corrected")

OUT

}

############
#FindHaplo
############
FindHaplo<-function(readfile=T,input=NA,align=NA,saveFile=T,outname="FindHaplo.txt")
{
library(ape)
if(readfile==T)
align<-read.dna(file=input,format="fasta")
mat_alin<-as.matrix(as.character(align))

seqs<-matrix(nrow=nrow(mat_alin),ncol=1)
for(i in 1:nrow(mat_alin))
seqs[i,]<-paste(mat_alin[i,],collapse="")

UH<-unique(seqs)
NH<-length(UH)
namesH<-matrix(nrow=NH,ncol=1)
for(i in 1:NH)
namesH[i,]<-(paste("H",i,sep=""))

out<-matrix(nrow=nrow(seqs),ncol=2)
colnames(out)<-c("Sequence.Name","Haplotype.Name")
out[,1]<-labels(align)

for(i in 1:NH)
out[which(seqs==UH[i,]),2]<-namesH[i,]

if(saveFile==T)
{
write.table(out,row.names=F,quote=F,file=outname)
}
out
}

############
#HapPerPop
############
HapPerPop<-function(readfile=T,sep=" ",header=F,inputFile=NA,input=NA,saveFile=T,Wname=NA,Iname=NA)
{
if (readfile==T)
{
input<-read.table(inputFile,sep=sep,header=header)
}
uhaplo<-sort(unique(input[,2]))
pops<-input[,1]
upops<-unique(pops)


matrizPresencia<-matrix(0,ncol=length(uhaplo),nrow=length(upops))
colnames(matrizPresencia)<-uhaplo
rownames(matrizPresencia)<-upops

for (i in 1:length(upops))
{
a<-input[which(upops[i]==input[,1]),2]
for(j in 1:length(a))
matrizPresencia[i,which(a[j]==colnames(matrizPresencia))]<-(1+matrizPresencia[i,which(a[j]==colnames(matrizPresencia))])
}

Pesos<-matrizPresencia
Interaccion<-matrizPresencia
Interaccion[which(matrizPresencia>0)]<-1

out<-list(c())
out[[1]]<-Pesos
out[[2]]<-Interaccion
names(out)<-c("Weighted","Interaction")

if(saveFile==T)
	{
		if(is.na(Wname))
			Wname<-"Weighted.txt"
		write.table(Pesos,file=Wname)

		if(is.na(Iname))
			Iname<-"Interaction.txt"
		write.table(Interaccion,file=Iname)
	}

out
}


############
#pop.dist
############
pop.dist<-function(DistFile=T,inputDist=NA,distances=NA,HaploFile=T,inputHaplo=NA,Haplos=NA,outType="O",logfile=TRUE,saveFile=TRUE,NameIni=NA,NameEnd=NA)
{
ifelse(HaploFile==T,
Haplos<-read.table(file=inputHaplo),
Haplos<-data.frame(Haplos))

pops<-unique(row.names(Haplos))

if(DistFile==T)
distances<-read.table(inputDist)
#row.names(distances)<-substr(row.names(distances),1,3)
#colnames(distances)<-substr(colnames(distances),1,3)


POPdist<-matrix("NA",nrow=length(pops),ncol=length(pops))
row.names(POPdist)<-pops
colnames(POPdist)<-pops

for (k in 1:nrow(POPdist))
POPdist[k,k]<-0

for(k in 1:(nrow(Haplos)-1))
for(l in (k+1):nrow(Haplos))
{
pop1<-Haplos[k,]
pop2<-Haplos[l,]

Hpop1<-rep(colnames(pop1)[which(pop1!=0)],pop1[which(pop1!=0)])
Hpop2<-rep(colnames(pop2)[which(pop2!=0)],pop2[which(pop2!=0)])

DIST1_2<-c()	
	for(i in 1:length(Hpop1))
	for(j in 1:length(Hpop2))
	DIST1_2<-c(DIST1_2,distances[which(row.names(distances)==substr(Hpop1[i],NameIni,NameEnd)),which(colnames(distances)==substr(Hpop2[i],NameIni,NameEnd))])
	if(length(DIST1_2)==0) DIST1_2<-0
	if(outType=="7"|outType=="O")
	POPdist[k,l]<-mean(DIST1_2)
	if(outType=="L"|outType=="O")
	POPdist[l,k]<-mean(DIST1_2)

	row.names(POPdist)<-pops
	colnames(POPdist)<-pops
}
if(logfile==T)
write.table(c(paste("Among haplotypes distance matrix used:",inputDist),paste("Haplotypes per population matix used",inputHaplo)),file=paste(inputDist,"_PopopulationDistances.r.txt.log",sep=""))
if(saveFile==T)
write.table(POPdist,file=paste(inputDist,"_PopulationDistances.r.txt",sep=""),na="")
#matrix(as.numeric(POPdist),nrow=nrow(POPdist))
#POPdist
as.data.frame(POPdist,nrow=nrow(POPdist))
}

############
#MCIC
############
MCIC<-function(readfile=T,input=NA,align=NA,saveFile=T,outname=paste(input,"IndelDistanceMatrixMullerMod.txt"))
{
library("ape")
if(readfile==T)
align<-read.dna(format="fasta",file=input) 				#read alignment
mat_alin<-as.matrix(as.character(align))					#alignment as matrix


gapMAL<-c()
for (i in 1:ncol(mat_alin))
if(paste(mat_alin[,i],collapse="")==paste(rep("-",nrow(mat_alin)),collapse=""))
gapMAL<-c(gapMAL,i)
if (is.null(gapMAL)==F) 
mat_alin<-mat_alin[,-c(gapMAL)] #removes positions full of gaps

seqNames<-row.names(mat_alin)

DISTANCE<-matrix(0,ncol=nrow(mat_alin),nrow=nrow(mat_alin))
colnames(DISTANCE)<-seqNames
row.names(DISTANCE)<-seqNames



for (i in 1:(nrow(mat_alin)-1))
for (j in (i+1):nrow(mat_alin))
	{

	if(i==1&j==(i+1)) print("Starting computation.......")
	if(i==1&j==(i+1)) print("...............0% completed")
	if(i==round(nrow(mat_alin)/4)&j==(i+1)) print("..............25% completed")
	if(i==round(nrow(mat_alin)/2)&j==(i+1)) print("..............50% completed")
	if(i==(nrow(mat_alin)-1)&j==(i+1)) print(".............100% completed")
	if(i==(nrow(mat_alin)-1)&j==(i+1)) print("FINISHED!!.................")

	sec1<-mat_alin[i,]
	sec2<-mat_alin[j,]

	recod1<-sec1
	recod2<-sec2

	for(l in 1:length(sec1))
		{
		if(sec1[l]=="-")
		recod1[l]<-0
		if(sec1[l]!="-")
		recod1[l]<-1
		if(sec2[l]=="-")
		recod2[l]<-0
		if(sec2[l]!="-")
		recod2[l]<-1
		}

	RECOD<-rbind(recod1,recod2)
	
	compact<-RECOD
	if(ncol(RECOD)>1)
		{
		borrar5<-c()
		for(l in 1:(ncol(RECOD)-1))
		if(paste(RECOD[,l],collapse="")==paste(RECOD[,(l+1)],collapse=""))
		borrar5<-c(borrar5,l+1)
		if(is.null(borrar5)==F)
		compact<-as.matrix(RECOD[,-borrar5])
		}
	
	compactSIN00<-compact
	if(ncol(compact)>1)
		{
		borrar6<-c()
		for(l in 1:ncol(compact))
		if(paste(compact[,l],collapse="")==paste(rep(0,2),collapse=""))
		borrar6<-c(borrar6,l)
		if(is.null(borrar6)==F)
		compactSIN00<-as.matrix(compact[,-borrar6])
		}
	
	compactMerged<-compactSIN00
	if(ncol(compactSIN00)>1)
		{
		borrar7<-c()
		for(l in 1:(ncol(compactSIN00)-1))
		if(
		compactSIN00[1,l]!=compactSIN00[2,l]
		&
		paste(compactSIN00[,l],collapse="")==paste(compactSIN00[,(l+1)],collapse=""))
		borrar7<-c(borrar7,(l+1))
		if(is.null(borrar7)==F)
		compactMerged<-as.matrix(compactSIN00[,-borrar7])
		}
	
	compactSIN11<-compactMerged
	if(ncol(compactMerged)>1)
		{
		borrar8<-c()
		for(l in 1:(ncol(compactMerged)))
		if(paste(compactMerged[,l],collapse="")==paste(c(1,1),collapse=""))
		borrar8<-c(borrar8,(l))
		if(is.null(borrar8)==F)
		compactSIN11<-as.matrix(compactMerged[,-borrar8])
		}
	
	DISTANCE[i,j]<-ncol(compactSIN11)
	DISTANCE[j,i]<-ncol(compactSIN11)
	}

if(saveFile==T)
write.table(DISTANCE,file=outname)
DISTANCE
}

############
#perc.thr
############

perc.thr<-function(dis,x=seq(0,1,0.01),ptPDF=TRUE,ptPDFname="PercolatedNetwork.pdf",estimPDF=TRUE,estimPDFname="PercThr Estimation.pdf",estimOutfile=TRUE, estimOutName="PercThresholdEstimation.txt",appendOutfile=TRUE,plotALL=FALSE,bgcol="white",label.col="black",label=colnames(dis),modules=FALSE)
{
 library(igraph)
 library (network)

salida<-matrix(nrow=length(x),ncol=3)
colnames(salida)<-c("Threshold","<s>","Clusters")

for (j in x)
{
print(paste("Threshold value:",j,"  Range to test: from ",min(x)," to ",max(x),sep=""))
dis2<-matrix(1,nrow=nrow(dis),ncol=ncol(dis))
lim<-max(dis)*j
fuera<-which(dis>lim)
dis2[fuera]<-0

G<-graph.adjacency(dis2)
A<-as.network.matrix(dis2)

Res<-clusters(G)
noGrande<-sort(Res$csize)[-length(sort(Res$csize))]
N<-sum(noGrande)
repes<-unique(noGrande[which(duplicated(noGrande))])
if (Res$no>1)
{
if (length(repes)>0)
{
n<-c()
for (i in 1:length(repes))
n<-c(n,length(which(noGrande==repes[i])))
sum1<-repes^2*n

noUnic<-c()
for (i in 1:length(repes))
noUnic<-c(noUnic,which(noGrande==repes[i]))
unicos<-noGrande[-noUnic]
sum2<-unicos^2

SUM<-sum(sum1)+sum(sum2)
S<-SUM/N
}

if (length(repes)==0)
S<-sum(noGrande^2)/N
}
if (Res$no==1)
S<-1
#print(c(j,S,Res$no))

salida[which(x==j),1]<-j
salida[which(x==j),2]<-S
salida[which(x==j),3]<-Res$no

if(is.null(colnames(dis)))
label<-c(1:ncol(dis))

if(plotALL==TRUE)
	{
		if(modules==T)
		{
		comuni<-walktrap.community(G)
		tab1<-matrix(nrow=nrow(dis2),ncol=2)
		tab1<-as.data.frame(tab1)
		tab1[,1]<-label
		tab1[,2]<-comuni$membership
		colores<-tab1[,2]

		bgcol<-colores
		}

	plot.network(A,vertex.col=as.matrix(bgcol),label=label,usearrows=0,vertex.cex=2.5,interactive=F,label.pos=5,label.col=label.col,label.cex=0.8,main=paste("Threshold=",j,sep=" "))
	dev.copy2pdf(file=paste("Threshold=",j,".pdf",sep=""))
	}
}

print("Preparing outfiles")

sal<-salida[,-3]
plot(sal,type="l")
points(sal)
if(estimPDF==TRUE)
dev.copy2pdf(file=estimPDFname)
if(estimOutfile==TRUE)
write.table(salida,file=estimOutName,append=appendOutfile)

out<-list(c())
out[[1]]<-salida
out[[2]]<-salida[(max(which(salida[,2]>1))+1),1]
names(out)<-c("Summary","Estimated Percolation Threshold")

#
j<-salida[(max(which(salida[,2]>1))+1),1]
dis2<-matrix(1,nrow=nrow(dis),ncol=ncol(dis))
row.names(dis2)<-row.names(dis)
lim<-max(dis)*j
fuera<-which(dis>lim)
dis2[fuera]<-0

G<-graph.adjacency(dis2)
A<-as.network.matrix(dis2)

		if(modules==T)
		{
		comuni<-walktrap.community(G)
		tab1<-matrix(nrow=nrow(dis2),ncol=2)
		tab1<-as.data.frame(tab1)
		tab1[,1]<-label
		tab1[,2]<-comuni$membership
		colo<-colors()[sample(1:657,length(unique(tab1[,2])))]
		for(i in 1:length(unique(tab1[,2])))
		tab1[which(tab1[,2]==(i-1)),3]<-colo[i]

		bgcol<-tab1[,3]
		out[[3]]<-tab1
		names(out)<-c("Summary","Estimated Percolation Threshold","Module")
		}

plot.network(A,vertex.col=as.matrix(bgcol),label=label,usearrows=0,vertex.cex=2.5,interactive=F,label.pos=5,label.col=label.col,label.cex=0.8,main=paste("Threshold=",j,sep=" "))
dev.copy2pdf(file=ptPDFname)

out
}

